/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.features;

import com.bitmark.apiservice.params.IssuanceParams;
import com.bitmark.apiservice.params.query.BitmarkQueryBuilder;
import com.bitmark.apiservice.response.GetBitmarksResponse;
import com.bitmark.apiservice.utils.Address;
import com.bitmark.apiservice.utils.Awaitility;
import com.bitmark.apiservice.utils.Pair;
import com.bitmark.apiservice.utils.callback.Callback1;
import com.bitmark.apiservice.utils.record.AssetRecord;
import com.bitmark.apiservice.utils.record.BitmarkRecord;
import com.bitmark.cryptography.crypto.key.KeyPair;
import com.bitmark.cryptography.error.ValidateException;
import com.bitmark.cryptography.utils.Validator;
import com.bitmark.sdk.features.Account;
import com.bitmark.sdk.features.Bitmark;
import com.bitmark.sdk.utils.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class Migration {
    public static void migrate(String[] phraseWords, Callback1<Pair<Account, List<String>>> callback) throws ValidateException {
        Validator.checkValid(() -> phraseWords != null && phraseWords.length == Version.TWENTY_FOUR.getMnemonicWordsLength(), (String)"Only support migrate from 24 recovery words ");
        Account oldAccount = Account.fromRecoveryPhrase(phraseWords);
        String oldAccountNumber = oldAccount.getAccountNumber();
        Account newAccount = new Account();
        try {
            List<GetBitmarksResponse> bitmarksResponses = Migration.getBitmarksResponses(oldAccountNumber);
            if (bitmarksResponses == null) {
                callback.onSuccess((Object)new Pair((Object)newAccount, Collections.emptyList()));
            } else {
                ArrayList bitmarkIds = new ArrayList();
                CompletableFuture.allOf((CompletableFuture[])bitmarksResponses.stream().map(response -> {
                    List bitmarks = response.getBitmarks();
                    List assets = response.getAssets();
                    return Migration.internalMigrate(newAccount, bitmarks, assets).whenComplete((result, throwable) -> {
                        if (throwable == null) {
                            bitmarkIds.addAll(result);
                        }
                    });
                }).toArray(CompletableFuture[]::new)).whenComplete((ignore, throwable) -> {
                    if (throwable != null) {
                        callback.onError(throwable.getCause());
                    } else {
                        callback.onSuccess((Object)new Pair((Object)newAccount, (Object)bitmarkIds));
                    }
                });
            }
        }
        catch (Throwable throwable2) {
            callback.onError(throwable2);
        }
    }

    private static List<GetBitmarksResponse> getBitmarksResponses(String accountNumber) throws Throwable {
        int limit = 100;
        ArrayList<GetBitmarksResponse> result = new ArrayList<GetBitmarksResponse>();
        List firstBitmarks = ((GetBitmarksResponse)Awaitility.await(internalCallback -> Bitmark.list(new BitmarkQueryBuilder().ownedBy(accountNumber).pending(Boolean.valueOf(true)).limit(Integer.valueOf(1)), (Callback1<GetBitmarksResponse>)internalCallback))).getBitmarks();
        if (firstBitmarks == null || firstBitmarks.isEmpty()) {
            return null;
        }
        Long lastOffset = ((BitmarkRecord)firstBitmarks.get(0)).getOffset();
        while (lastOffset != null) {
            int size;
            BitmarkQueryBuilder builder = new BitmarkQueryBuilder().ownedBy(accountNumber).at(lastOffset).to("earlier").loadAsset(Boolean.valueOf(true)).pending(Boolean.valueOf(true)).limit(Integer.valueOf(100));
            GetBitmarksResponse response = (GetBitmarksResponse)Awaitility.await(internalCallback -> Bitmark.list(builder, (Callback1<GetBitmarksResponse>)internalCallback));
            result.add(response);
            List bitmarks = response.getBitmarks();
            int n = size = bitmarks == null ? 0 : bitmarks.size();
            if (size == 100) {
                lastOffset = ((BitmarkRecord)bitmarks.get(bitmarks.size() - 1)).getOffset();
                continue;
            }
            lastOffset = null;
        }
        return result;
    }

    private static CompletableFuture<List<String>> internalMigrate(Account owner, List<BitmarkRecord> bitmarks, List<AssetRecord> assets) {
        Address ownerAddress = owner.toAddress();
        KeyPair key = owner.getKey();
        ArrayList params = new ArrayList();
        assets.forEach(asset -> {
            String assetId = asset.getId();
            int quantity = (int)bitmarks.stream().filter(bitmark -> bitmark.getAssetId().equals(assetId)).count();
            IssuanceParams param = new IssuanceParams(assetId, ownerAddress, quantity);
            param.sign(key);
            params.add(param);
        });
        ArrayList bitmarkIds = new ArrayList();
        CompletableFuture<List<String>> emitters = new CompletableFuture<List<String>>();
        CompletableFuture.allOf((CompletableFuture[])params.stream().map(param -> Migration.issue(param).whenComplete((result, throwable) -> {
            if (throwable == null) {
                bitmarkIds.addAll(result);
            }
        })).toArray(CompletableFuture[]::new)).whenComplete((result, throwable) -> {
            if (throwable != null) {
                emitters.completeExceptionally(throwable.getCause());
            } else {
                emitters.complete(bitmarkIds);
            }
        });
        return emitters;
    }

    private static CompletableFuture<List<String>> issue(IssuanceParams params) {
        final CompletableFuture<List<String>> emitter = new CompletableFuture<List<String>>();
        Bitmark.issue(params, new Callback1<List<String>>(){

            public void onSuccess(List<String> data) {
                emitter.complete(data);
            }

            public void onError(Throwable throwable) {
                emitter.completeExceptionally(throwable);
            }
        });
        return emitter;
    }
}

