/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.features;

import com.bitmark.apiservice.configuration.GlobalConfiguration;
import com.bitmark.apiservice.configuration.Network;
import com.bitmark.apiservice.utils.ArrayUtil;
import com.bitmark.apiservice.utils.error.UnexpectedException;
import com.bitmark.cryptography.error.ValidateException;
import com.bitmark.cryptography.utils.Validator;
import com.bitmark.sdk.features.Seed;
import com.bitmark.sdk.utils.FileUtils;
import com.bitmark.sdk.utils.SdkUtils;
import com.bitmark.sdk.utils.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;

public class RecoveryPhrase {
    private final String[] mnemonicWords;
    private static String[] EN_WORDS;
    private static String[] CN_WORDS;
    private static final int[] MASKS;

    private static String[] getWords(Locale locale) {
        Validator.checkValid(() -> locale == Locale.ENGLISH || locale == Locale.CHINESE, (String)"Does not support this locale");
        if (locale == Locale.ENGLISH && EN_WORDS != null) {
            return EN_WORDS;
        }
        if (locale == Locale.CHINESE && CN_WORDS != null) {
            return CN_WORDS;
        }
        try {
            String word;
            int size = 2048;
            File file = FileUtils.getResourceAsFile(locale == Locale.ENGLISH ? "bip/bip39_eng.txt" : "bip/bip39_cn.txt");
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String[] words = new String[2048];
            for (int i = 0; i < 2048 && (word = reader.readLine()) != null; ++i) {
                words[i] = word;
            }
            if (locale == Locale.ENGLISH) {
                EN_WORDS = words;
            } else {
                CN_WORDS = words;
            }
            return words;
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage());
        }
    }

    public static RecoveryPhrase fromSeed(Seed seed) throws ValidateException {
        return RecoveryPhrase.fromSeed(seed, Locale.ENGLISH);
    }

    public static RecoveryPhrase fromSeed(Seed seed, Locale locale) throws ValidateException {
        Validator.checkValid(() -> seed != null && Version.matchesCore(seed.getSeed()), (String)"Invalid Seed");
        byte[] core = seed.getSeed();
        Version version = Version.fromCore(core);
        return version == Version.TWELVE ? new RecoveryPhrase(RecoveryPhrase.generateMnemonic(core, locale)) : new RecoveryPhrase(RecoveryPhrase.generateMnemonic(ArrayUtil.concat((byte[])ArrayUtil.toByteArray((int)seed.getNetwork().value()), (byte[])core), locale));
    }

    public static RecoveryPhrase fromMnemonicWords(String ... mnemonicWords) throws ValidateException {
        return new RecoveryPhrase(mnemonicWords);
    }

    public RecoveryPhrase() {
        byte[] entropy = SdkUtils.randomEntropy(GlobalConfiguration.network());
        this.mnemonicWords = RecoveryPhrase.generateMnemonic(entropy);
    }

    private RecoveryPhrase(String ... mnemonicWords) throws ValidateException {
        RecoveryPhrase.validate(mnemonicWords);
        this.mnemonicWords = mnemonicWords;
    }

    public String[] getMnemonicWords() {
        return this.mnemonicWords;
    }

    public Seed recoverSeed() {
        return RecoveryPhrase.recoverSeed(this.mnemonicWords);
    }

    public static Seed recoverSeed(String[] mnemonicWord) throws ValidateException {
        RecoveryPhrase.validate(mnemonicWord);
        Version version = Version.fromMnemonicWords(mnemonicWord);
        int wordsLength = version.getMnemonicWordsLength();
        int coreLength = version.getCoreLength();
        int entropyLength = version == Version.TWELVE ? coreLength : coreLength + 1;
        Locale locale = RecoveryPhrase.detectLocale(mnemonicWord[0]);
        if (locale == null) {
            throw new ValidateException("Does not support this language");
        }
        Object[] words = RecoveryPhrase.getWords(locale);
        int[] data = new int[]{};
        int remainder = 0;
        int bits = 0;
        for (int i = 0; i < wordsLength; ++i) {
            String word = mnemonicWord[i];
            int index = ArrayUtil.indexOf((Object[])words, (Object)word);
            remainder = (remainder << 11) + index;
            bits += 11;
            while (bits >= 8) {
                int a = 0xFF & remainder >> bits - 8;
                data = ArrayUtil.concat((int[])data, (int[])new int[]{a});
                bits -= 8;
            }
            remainder &= MASKS[bits];
        }
        byte[] entropy = version == Version.TWELVE ? ArrayUtil.concat((byte[])ArrayUtil.toByteArray((int[])data), (byte[])new byte[]{(byte)(remainder << 4)}) : ArrayUtil.toByteArray((int[])data);
        Validator.checkValid(() -> entropy.length == entropyLength, (String)"Invalid mnemonic words");
        if (version == Version.TWELVE) {
            return new Seed(entropy);
        }
        Network network = Network.valueOf((int)entropy[0]);
        byte[] core = ArrayUtil.slice((byte[])entropy, (int)1, (int)entropyLength);
        return new Seed(core, network);
    }

    public static String[] generateMnemonic(byte[] entropy) throws ValidateException {
        return RecoveryPhrase.generateMnemonic(entropy, Locale.ENGLISH);
    }

    public static String[] generateMnemonic(byte[] entropy, Locale locale) throws ValidateException {
        Validator.checkValid(() -> entropy != null && Version.matchesEntropy(entropy), (String)"Invalid entropy");
        String[] words = RecoveryPhrase.getWords(locale);
        Version version = Version.fromEntropy(entropy);
        int mnenonicWordsLength = version.getMnemonicWordsLength();
        int entropyLength = version.getEntropyLength();
        ArrayList<String> mnemonicWords = new ArrayList<String>(mnenonicWordsLength);
        int[] unsignedEntropy = ArrayUtil.toUInt((byte[])entropy);
        int accumulator = 0;
        int bits = 0;
        for (int i = 0; i < entropyLength; ++i) {
            accumulator = (accumulator << 8) + unsignedEntropy[i];
            if ((bits += 8) < 11) continue;
            int index = accumulator >> (bits -= 11);
            accumulator &= MASKS[bits];
            mnemonicWords.add(words[index]);
        }
        return mnemonicWords.toArray(new String[mnenonicWordsLength]);
    }

    private static void validate(String ... mnemonicWords) {
        Validator.checkValid(() -> mnemonicWords != null && Version.matchesMnemonicWords(mnemonicWords) && (ArrayUtil.contains((Object[])RecoveryPhrase.getWords(Locale.ENGLISH), (Object[])mnemonicWords) || ArrayUtil.contains((Object[])RecoveryPhrase.getWords(Locale.CHINESE), (Object[])mnemonicWords)));
    }

    private static Locale detectLocale(String examined) {
        return ArrayUtil.contains((Object[])RecoveryPhrase.getWords(Locale.ENGLISH), (Object)examined) ? Locale.ENGLISH : (ArrayUtil.contains((Object[])RecoveryPhrase.getWords(Locale.CHINESE), (Object)examined) ? Locale.CHINESE : null);
    }

    static {
        MASKS = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023};
    }
}

