/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.features;

import com.bitmark.apiservice.configuration.GlobalConfiguration;
import com.bitmark.apiservice.configuration.Network;
import com.bitmark.apiservice.utils.ArrayUtil;
import com.bitmark.apiservice.utils.error.InvalidNetworkException;
import com.bitmark.cryptography.crypto.Sha3256;
import com.bitmark.cryptography.crypto.encoder.Base58;
import com.bitmark.cryptography.crypto.encoder.VarInt;
import com.bitmark.cryptography.error.ValidateException;
import com.bitmark.cryptography.utils.Validator;
import com.bitmark.sdk.utils.SdkUtils;
import com.bitmark.sdk.utils.SequenceIterateByteArray;
import com.bitmark.sdk.utils.Version;
import com.bitmark.sdk.utils.error.InvalidChecksumException;
import com.bitmark.sdk.utils.error.InvalidSeedException;
import java.util.Arrays;

public class Seed {
    private static final int CHECKSUM_LENGTH = 4;
    private static final byte[] TWELVE_HEADER = new byte[]{90, -2, 2};
    private static final byte[] TWENTY_FOUR_HEADER = new byte[]{90, -2};
    private static final int VERSION = 1;
    private static final int NETWORK_LENGTH = 1;
    private byte[] seed;
    private Network network;

    public static Seed fromEncodedSeed(String encodedSeed) throws ValidateException {
        Version version = Version.fromEncodedSeed(encodedSeed);
        byte[] seedBytes = Base58.BASE_58.decode(encodedSeed);
        int encodedSeedLength = version.getEncodedSeedLength();
        Validator.checkValidLength((byte[])seedBytes, (int)encodedSeedLength);
        return version == Version.TWELVE ? Seed.fromTwelveVerEncodedSeed(seedBytes) : Seed.fromTwentyFourVerEncodedSeed(seedBytes);
    }

    private static Seed fromTwelveVerEncodedSeed(byte[] seedBytes) {
        int seedLength = Version.TWELVE.getCoreLength();
        int length = seedBytes.length;
        byte[] checksum = ArrayUtil.slice((byte[])seedBytes, (int)(length - 4), (int)length);
        byte[] data = Arrays.copyOfRange(seedBytes, 0, length - 4);
        byte[] dataHashed = Sha3256.hash((byte[])data);
        byte[] checksumVerification = ArrayUtil.slice((byte[])dataHashed, (int)0, (int)4);
        Validator.checkValid(() -> Arrays.equals(checksum, checksumVerification), (ValidateException)new InvalidChecksumException(checksumVerification, checksum));
        byte[] seed = ArrayUtil.slice((byte[])data, (int)TWELVE_HEADER.length, (int)data.length);
        Validator.checkValidLength((byte[])seed, (int)seedLength);
        return new Seed(seed);
    }

    private static Seed fromTwentyFourVerEncodedSeed(byte[] seedBytes) {
        int seedLength = Version.TWENTY_FOUR.getCoreLength();
        int length = seedBytes.length;
        byte[] checksum = ArrayUtil.slice((byte[])seedBytes, (int)(length - 4), (int)length);
        SequenceIterateByteArray data = new SequenceIterateByteArray(Arrays.copyOfRange(seedBytes, 0, length - 4));
        byte[] dataHashed = Sha3256.hash((byte[])data.getBytes());
        byte[] checksumVerification = ArrayUtil.slice((byte[])dataHashed, (int)0, (int)4);
        Validator.checkValid(() -> Arrays.equals(checksum, checksumVerification), (ValidateException)new InvalidChecksumException(checksumVerification, checksum));
        byte[] magicNumber = data.next(TWENTY_FOUR_HEADER.length);
        Validator.checkValid(() -> Arrays.equals(magicNumber, TWENTY_FOUR_HEADER), (ValidateException)new InvalidSeedException.InvalidMagicNumberException(magicNumber, TWENTY_FOUR_HEADER));
        byte[] encodedSeedVersion = VarInt.writeUnsignedVarInt((int)1);
        byte[] version = data.next(encodedSeedVersion.length);
        Validator.checkValid(() -> Arrays.equals(version, encodedSeedVersion), (ValidateException)new InvalidSeedException.InvalidVersionException(version, encodedSeedVersion));
        int network = ArrayUtil.toPrimitiveInteger((byte[])data.next(1));
        Validator.checkValid(() -> Network.isValid((int)network), (ValidateException)new InvalidNetworkException(network));
        byte[] seed = data.next();
        Validator.checkValidLength((byte[])seed, (int)seedLength);
        return new Seed(seed, Network.valueOf((int)network));
    }

    public Seed(byte[] seed) throws ValidateException {
        Validator.checkValid(() -> seed != null && Version.matchesCore(seed));
        this.seed = seed;
        this.network = Version.fromCore(seed) == Version.TWELVE ? SdkUtils.extractNetwork(seed) : GlobalConfiguration.network();
    }

    public Seed(byte[] seed, Network network) throws ValidateException {
        Validator.checkValid(() -> seed != null && Version.matchesCore(seed) && network != null);
        Version version = Version.fromCore(seed);
        if (version == Version.TWELVE && SdkUtils.extractNetwork(seed) != network) {
            throw new ValidateException("Invalid network");
        }
        this.seed = seed;
        this.network = network;
    }

    public String getEncodedSeed() {
        return Version.fromCore(this.seed) == Version.TWELVE ? this.getTwelveVerEncodedSeed() : this.getTwentyFourVerEncodedSeed();
    }

    private String getTwelveVerEncodedSeed() {
        byte[] data = ArrayUtil.concat((byte[])TWELVE_HEADER, (byte[])this.seed);
        byte[] checksum = ArrayUtil.slice((byte[])Sha3256.hash((byte[])data), (int)0, (int)4);
        byte[] seed = ArrayUtil.concat((byte[])data, (byte[])checksum);
        return Base58.BASE_58.encode(seed);
    }

    private String getTwentyFourVerEncodedSeed() {
        byte[] network = VarInt.writeUnsignedVarInt((int)this.network.value());
        byte[] encodedSeedVersion = VarInt.writeUnsignedVarInt((int)1);
        byte[] data = ArrayUtil.concat((byte[])TWENTY_FOUR_HEADER, (byte[])encodedSeedVersion, (byte[])network, (byte[])this.seed);
        byte[] checksum = ArrayUtil.slice((byte[])Sha3256.hash((byte[])data), (int)0, (int)4);
        byte[] seed = ArrayUtil.concat((byte[])data, (byte[])checksum);
        return Base58.BASE_58.encode(seed);
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public Network getNetwork() {
        return this.network;
    }
}

