/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.utils;

import com.bitmark.sdk.features.RecoveryPhrase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtils {
    private FileUtils() {
    }

    public static InputStream getResourceAsStream(String name) throws IOException {
        ClassLoader[] loaders = new ClassLoader[]{ClassLoader.getSystemClassLoader(), RecoveryPhrase.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        String[] paths = new String[]{name, "/" + name};
        for (ClassLoader loader : loaders) {
            String path;
            InputStream stream = null;
            String[] stringArray = paths;
            int n = stringArray.length;
            for (int i = 0; i < n && (stream = loader.getResourceAsStream(path = stringArray[i])) == null; ++i) {
            }
            if (stream == null) continue;
            return stream;
        }
        throw new IOException("File with path " + name + " is not found");
    }

    public static File getResourceAsFile(String name) throws IOException {
        String suffix = name.substring(name.lastIndexOf("."));
        String prefix = name.substring(name.lastIndexOf("/") + 1, name.lastIndexOf("."));
        String fileName = prefix + suffix;
        File tmpFile = new File(FileUtils.getTmpDir() + "/" + fileName);
        if (!tmpFile.exists()) {
            try (OutputStream os = null;){
                InputStream is = FileUtils.getResourceAsStream(name);
                byte[] buffer = new byte[is.available()];
                is.read(buffer);
                os = new FileOutputStream(tmpFile);
                os.write(buffer);
            }
        }
        return tmpFile;
    }

    private static String getTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }
}

