/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.utils;

import com.bitmark.apiservice.configuration.Network;
import com.bitmark.apiservice.utils.ArrayUtil;
import com.bitmark.apiservice.utils.error.InvalidNetworkException;
import com.bitmark.cryptography.crypto.Random;
import com.bitmark.cryptography.crypto.Sha3256;
import com.bitmark.cryptography.error.ValidateException;
import com.bitmark.cryptography.utils.Validator;
import com.bitmark.sdk.utils.SequenceIterateByteArray;
import java.util.ArrayList;
import java.util.List;

public class SdkUtils {
    public static final int CORE_LENGTH = 17;

    private SdkUtils() {
    }

    public static byte[] randomEntropy(Network network) {
        byte[] seed = Random.secureRandomBytes((int)16);
        seed = ArrayUtil.concat((byte[])seed, (byte[])new byte[]{(byte)(seed[15] & 0xF0)});
        byte mode = (byte)(seed[0] & 0x80 | seed[1] & 0x40 | seed[2] & 0x20 | seed[3] & 0x10);
        if (network == Network.TEST_NET) {
            mode = (byte)(mode ^ 0xF0);
        }
        seed[15] = (byte)(mode | seed[15] & 0xF);
        return seed;
    }

    public static Network extractNetwork(byte[] core) throws InvalidNetworkException {
        int mode = core[0] & 0x80 | core[1] & 0x40 | core[2] & 0x20 | core[3] & 0x10;
        if (mode == (core[15] & 0xF0)) {
            return Network.LIVE_NET;
        }
        if (mode == (core[15] & 0xF0 ^ 0xF0)) {
            return Network.TEST_NET;
        }
        throw new InvalidNetworkException("Cannot extract network from core");
    }

    public static byte[] generateSeedKey(byte[] core, int keySize) throws ValidateException {
        List<byte[]> keys = SdkUtils.generateSeedKeys(core, 1, keySize);
        if (keys.isEmpty()) {
            throw new ValidateException("Generate seed key failed");
        }
        return keys.get(0);
    }

    public static List<byte[]> generateSeedKeys(byte[] core, int keyCount, int keySize) throws ValidateException {
        Validator.checkValid(() -> core != null && core.length > 0 && keyCount > 0 && keySize > 0);
        int length = keySize * 8 * keyCount;
        byte[] hash = Sha3256.shake((byte[])core, (int)length, (int)4);
        ArrayList<byte[]> keys = new ArrayList<byte[]>(keyCount);
        SequenceIterateByteArray array = new SequenceIterateByteArray(hash);
        for (int i = 0; i < keyCount; ++i) {
            keys.add(array.next(keySize));
        }
        return keys;
    }
}

