/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.utils;

import com.bitmark.cryptography.crypto.encoder.Base58;
import com.bitmark.cryptography.error.ValidateException;

public enum Version {
    TWELVE,
    TWENTY_FOUR;


    public static Version fromCore(byte[] core) throws ValidateException {
        Version version;
        int length = core.length;
        Version version2 = length == 17 ? TWELVE : (version = length == 32 ? TWENTY_FOUR : null);
        if (version == null) {
            throw new ValidateException("Invalid core length " + length);
        }
        return version;
    }

    public static Version fromMnemonicWords(String ... words) throws ValidateException {
        Version version;
        int length = words.length;
        Version version2 = length == 12 ? TWELVE : (version = length == 24 ? TWENTY_FOUR : null);
        if (version == null) {
            throw new ValidateException("Invalid mnemonic word length " + length);
        }
        return version;
    }

    public static Version fromEncodedSeed(String encodedSeed) throws ValidateException {
        Version version;
        int length = Base58.BASE_58.decode(encodedSeed).length;
        Version version2 = length == 24 ? TWELVE : (version = length == 40 ? TWENTY_FOUR : null);
        if (version == null) {
            throw new ValidateException("Invalid encoded seed length" + length);
        }
        return version;
    }

    public static Version fromEntropy(byte[] entropy) throws ValidateException {
        Version version;
        int length = entropy.length;
        Version version2 = length == 17 ? TWELVE : (version = length == 33 ? TWENTY_FOUR : null);
        if (version == null) {
            throw new ValidateException("Invalid entropy length " + length);
        }
        return version;
    }

    public static boolean matchesMnemonicWords(String ... words) {
        try {
            Version.fromMnemonicWords(words);
            return true;
        }
        catch (ValidateException e) {
            return false;
        }
    }

    public static boolean matchesCore(byte[] core) {
        try {
            Version.fromCore(core);
            return true;
        }
        catch (ValidateException e) {
            return false;
        }
    }

    public static boolean matchesEntropy(byte[] entropy) {
        try {
            Version.fromEntropy(entropy);
            return true;
        }
        catch (ValidateException e) {
            return false;
        }
    }

    public int getCoreLength() {
        return this == TWELVE ? 17 : 32;
    }

    public int getMnemonicWordsLength() {
        return this == TWELVE ? 12 : 24;
    }

    public int getEncodedSeedLength() {
        return this == TWELVE ? 24 : 40;
    }

    public int getEntropyLength() {
        return this == TWELVE ? 17 : 33;
    }
}

