/*
 * Decompiled with CFR 0.152.
 */
package com.bitmark.sdk.utils.error;

import com.bitmark.cryptography.crypto.encoder.Hex;
import com.bitmark.cryptography.error.ValidateException;

public class InvalidSeedException
extends ValidateException {
    public InvalidSeedException(String message) {
        super(message);
    }

    public static class InvalidVersionException
    extends InvalidSeedException {
        public InvalidVersionException(String message) {
            super(message);
        }

        public InvalidVersionException(int actual, int expected) {
            this("Invalid version. Expected is " + expected + " but actual is " + actual);
        }

        public InvalidVersionException(byte[] actual, byte[] expected) {
            this("Invalid version. Expected is " + Hex.HEX.encode(expected) + " but actual is " + Hex.HEX.encode(actual));
        }
    }

    public static class InvalidMagicNumberException
    extends InvalidSeedException {
        public InvalidMagicNumberException(String message) {
            super(message);
        }

        public InvalidMagicNumberException(byte[] actual, byte[] expected) {
            this("Invalid magic number. Expected is " + Hex.HEX.encode(expected) + " but actual is " + Hex.HEX.encode(actual));
        }
    }
}

