package com.btjava.common.utils.text;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

public class DataTools
{
    /**
     * 生成UUID
     * @return
     */
    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String md5(String plainText) {
        byte[] secretBytes = null;
        try {
            secretBytes = MessageDigest.getInstance("md5").digest(
                    plainText.getBytes("UTF-8"));
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("没有这个md5算法！");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String md5code = new BigInteger(1, secretBytes).toString(16);
        for (int i = 0; i < 32 - md5code.length(); i++) {
            md5code = "0" + md5code;
        }
        return md5code;
    }

    /**
     * 密码加密
     * @param pwd 明文密码
     * @param userMap 用户对象
     * @return 密码密文
     * @throws ParseException
     */
    public static String encodePwd(String pwd,Map<String,Object> userMap) throws ParseException{
        return encodePwd(pwd,userMap.get("userId").toString().trim(),new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(userMap.get("regTime").toString().trim()));
    }
    /**
     * 密码加密
     * @param pwd 明文密码
     * @param uid uid
     * @param date 时间
     * @return 密码密文
     */
    public static String encodePwd(String pwd,String uid,Date date){
        //MD5加密
        pwd =md5(pwd);
        //根据时间最后五位和UID进行替换
        Long time = date.getTime()/1000;
        int lastNum = Integer.parseInt((time%100000)+"");
        pwd =removeChar(pwd,lastNum);
        pwd =addChar(pwd,uid,lastNum);
        pwd=md5(pwd);
        return pwd;
    }

    /**
     * 删除指定字符
     * @param s
     * @param num
     * @return
     */
    private static String removeChar(String s,int num){
        if(num !=0){
            int n= (num%10)+1;
            s=s.substring(0,n-1) +s.substring(n);
            num = num/10;
            s=removeChar(s,num);
        }
        return s;
    }

    /**
     * 为s1混入s2的指定字符串
     * @param s1
     * @param s2
     * @param num
     * @return
     */
    private static String addChar(String s1,String s2,int num){
        if(num !=0){
            int n= (num%10);
            s1=s1.substring(0,n)+s2.charAt(n)+s1.substring(n);
            num = num/10;
            s1=addChar(s1,s2,num);
        }
        return s1;
    }

    /**
     * 获取Map中的值，返回NULL或非空字符串
     * @param paramMap
     * @param attr
     * @return
     */
    public static String getAttrByName(Map<String,Object> paramMap ,String attr){
        String str =paramMap.containsKey(attr)&& paramMap.get(attr) !=null && !"".equals(paramMap.get(attr).toString().trim())
                ? paramMap.get(attr).toString().trim() :null;
        return str;
    }

    /**
     * 从map中获取指定对象
     * @param paramMap
     * @param key
     * @return
     */
    public static Object getObjByMap(Map<String,Object> paramMap,String key){
        return paramMap.containsKey(key) && paramMap.get(key) !=null
                && !"".equals(paramMap.get(key))? paramMap.get(key):null;
    }
    /**
     * 把一个存放Map的List，按照指定的key的值为行Map的key转换成Map。
     * 如果指定value,就使用value所取出的值为value，则使用key所在Map为value.
     * 		(使用该方法时，请保证key和value一定存在于每个Map中)
     * @param list
     * @param key
     * @param value
     * @return
     */
    public static Map<String,Object> ListToMap(List<Map<String,Object>> list, String key, String value){
        Map<String,Object> map = new HashMap<String,Object>();
        boolean flag =true;
        if(value ==null || "".equals(value.trim())){
            flag =false;
        }
        for(Map<String,Object> m:list){
            if(flag){
                if(m.containsKey(key)){
                    if(m.containsKey(value)){
                        map.put(m.get(key).toString(),m.get(value));
                    }else{
                        map.put(m.get(key).toString(),null);
                    }
                }
            }else{
                if(m.containsKey(key)){
                    map.put(m.get(key).toString(),m);
                }
            }
        }
        return map;
    }

    /**
     * 获取随机数
     * @param max 最大范围
     * @return
     */
    public static int getRandomInt(int max){
        Random random = new Random();
        return random.nextInt(max);
    }

    /**
     * 对象转成map
     * @param obj 要转换的对象
     * @return
     * @throws Exception
     */
    public static Map<String, Object> objectToMap(Object obj) throws Exception {
        if(obj == null){
            return null;
        }

        Map<String, Object> map = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (PropertyDescriptor property : propertyDescriptors) {
            String key = property.getName();
            if (key.compareToIgnoreCase("class") == 0) {
                continue;
            }
            Method getter = property.getReadMethod();
            Object value = getter!=null ? getter.invoke(obj) : null;
            map.put(key, value);
        }

        return map;
    }
}
