/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.value;

import com.cedarpolicy.value.Value;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class EntityUID
extends Value {
    private final String euid;
    private final Optional<String> type;
    private final Optional<String> id;

    public EntityUID(String euid) throws IllegalArgumentException {
        if (!EUIDValidator.validEntityUID(euid)) {
            throw new IllegalArgumentException("Input string is not a valid EntityUID " + euid);
        }
        this.euid = euid;
        this.type = Optional.empty();
        this.id = Optional.empty();
    }

    public EntityUID(String type, String id) throws IllegalArgumentException {
        String euid = type + "::\"" + id + "\"";
        if (!EUIDValidator.validEntityUID(euid)) {
            throw new IllegalArgumentException("Input string is not a valid EntityUID " + euid);
        }
        this.euid = euid;
        this.type = Optional.of(type);
        this.id = Optional.of(id);
    }

    public String toString() {
        return this.euid;
    }

    @Override
    public String toCedarExpr() {
        return this.euid;
    }

    public String getType() {
        if (!this.type.isEmpty()) {
            return this.type.get();
        }
        return this.euid.substring(0, this.euid.length() - this.getId().length() - 4);
    }

    public String getId() {
        if (!this.id.isEmpty()) {
            return this.id.get();
        }
        String[] strs = this.euid.split("::");
        return strs[strs.length - 1].substring(1, strs[strs.length - 1].length() - 1);
    }

    private static class EUIDValidator {
        private static final String anyCharExceptSlashOrQuote = "[^\\\"\\\\]";
        private static final String escapedSlash = "\\\\\\\\";
        private static final String escapedQuote = "\\\\\\\"";
        private static final String unicodeEscapedPattern = "\\\\u[A-Fa-f0-9]{4,6}";
        private static final Pattern entityUIDPattern = Pattern.compile("^([A-Za-z_]([A-Za-z0-9_])*::)+\"([^\\\"\\\\]|\\\\\\\\|\\\\\\\"|\\\\u[A-Fa-f0-9]{4,6})*\"$");
        private static final long MAXLENGTH = 1024L;

        private EUIDValidator() {
        }

        public static boolean validEntityUID(String id) {
            if (id == null || id.isEmpty()) {
                return false;
            }
            if ((long)(id = id.trim()).length() > 1024L) {
                return false;
            }
            try {
                Matcher matcher = entityUIDPattern.matcher(id);
                return matcher.matches();
            }
            catch (PatternSyntaxException ex) {
                return false;
            }
        }
    }
}

