/*
 * Copyright 2022-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.cedarpolicy.model.slice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Instantiation for policy template. */
public class Instantiation {
    private final String slot;
    private final EntityTypeAndId value;

    /**
     * Instantiation for policy template.
     *
     * @param slot the slot in the template.
     * @param value the value to put in the slot
     */
    @JsonCreator
    public Instantiation(
            @JsonProperty("slot") String slot, @JsonProperty("value") EntityTypeAndId value) {
        this.slot = slot;
        this.value = value;
    }


    /** Get the slot in the template. */
    public String getSlot() {
        return slot;
    }

    /** Get the value to put in the slot. */
    public EntityTypeAndId getValue() {
        return value;
    }
}
