/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.cedarpolicy.model.schema.Schema;
import com.cedarpolicy.model.slice.Policy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class ValidationRequest {
    private final Schema schema;
    private final Map<String, String> policySet;

    @SuppressFBWarnings
    public ValidationRequest(Schema schema, Map<String, String> policySet) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (policySet == null) {
            throw new NullPointerException("policySet");
        }
        this.schema = schema;
        this.policySet = policySet;
    }

    public ValidationRequest(Schema schema, Set<Policy> policySet) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (policySet == null) {
            throw new NullPointerException("policySet");
        }
        this.schema = schema;
        this.policySet = new HashMap<String, String>();
        for (Policy p : policySet) {
            this.policySet.put(p.policyID, p.policySrc);
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    @SuppressFBWarnings
    public Map<String, String> getPolicySet() {
        return this.policySet;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ValidationRequest)) {
            return false;
        }
        ValidationRequest other = (ValidationRequest)o;
        return this.schema.equals(other.schema) && this.policySet.equals(other.policySet);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.policySet);
    }

    public String toString() {
        return "ValidationRequest(schema=" + this.schema + ", policySet=" + this.policySet + ")";
    }
}

