/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.serializer;

import com.cedarpolicy.model.exception.DeserializationRecursionDepthException;
import com.cedarpolicy.model.exception.InvalidValueDeserializationException;
import com.cedarpolicy.value.CedarList;
import com.cedarpolicy.value.CedarMap;
import com.cedarpolicy.value.Decimal;
import com.cedarpolicy.value.EntityUID;
import com.cedarpolicy.value.IpAddress;
import com.cedarpolicy.value.PrimBool;
import com.cedarpolicy.value.PrimLong;
import com.cedarpolicy.value.PrimString;
import com.cedarpolicy.value.Value;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class ValueCedarDeserializer
extends JsonDeserializer<Value> {
    private static final String ENTITY_ESCAPE_SEQ = "__entity";
    private static final String EXTENSION_ESCAPE_SEQ = "__extn";

    public Value deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        try {
            if (node.canConvertToLong()) {
                return new PrimLong(node.asLong());
            }
            if (node.isBoolean()) {
                return new PrimBool(node.asBoolean());
            }
            if (node.isTextual()) {
                return new PrimString(node.asText());
            }
            if (node.isArray()) {
                CedarList myNode = new CedarList();
                Iterator iter = node.elements();
                while (iter.hasNext()) {
                    myNode.add((Value)mapper.treeToValue((TreeNode)iter.next(), Value.class));
                }
                return myNode;
            }
            if (node.isObject()) {
                Iterator iter = node.fields();
                EscapeType escapeType = EscapeType.UNRECOGNIZED;
                int count = 0;
                while (iter.hasNext()) {
                    ++count;
                    Map.Entry entry = (Map.Entry)iter.next();
                    if (((String)entry.getKey()).equals(ENTITY_ESCAPE_SEQ)) {
                        escapeType = EscapeType.ENTITY;
                        continue;
                    }
                    if (!((String)entry.getKey()).equals(EXTENSION_ESCAPE_SEQ)) continue;
                    escapeType = EscapeType.EXTENSION;
                }
                if (escapeType != EscapeType.UNRECOGNIZED) {
                    if (count == 1) {
                        JsonNode val;
                        if (escapeType == EscapeType.ENTITY) {
                            val = node.get(ENTITY_ESCAPE_SEQ);
                            if (val.isTextual()) {
                                return new EntityUID(val.textValue());
                            }
                            if (val.isObject() && val.has("id") && val.has("type")) {
                                int num_fields = 0;
                                Iterator it = val.fieldNames();
                                while (it.hasNext()) {
                                    ++num_fields;
                                    it.next();
                                }
                                if (num_fields == 2) {
                                    return new EntityUID(val.get("type").textValue(), val.get("id").textValue());
                                }
                            }
                            throw new InvalidValueDeserializationException(parser, "Not textual node: " + node.toString(), node.asToken(), Map.class);
                        }
                        val = node.get(EXTENSION_ESCAPE_SEQ);
                        JsonNode fn = val.get("fn");
                        if (!fn.isTextual()) {
                            throw new InvalidValueDeserializationException(parser, "Not textual node: " + fn.toString(), node.asToken(), Map.class);
                        }
                        JsonNode arg = val.get("arg");
                        if (!arg.isTextual()) {
                            throw new InvalidValueDeserializationException(parser, "Not textual node: " + arg.toString(), node.asToken(), Map.class);
                        }
                        if (fn.textValue().equals("ip")) {
                            return new IpAddress(arg.textValue());
                        }
                        if (fn.textValue().equals("decimal")) {
                            return new Decimal(arg.textValue());
                        }
                        throw new InvalidValueDeserializationException(parser, "Invalid function type: " + fn.toString(), node.asToken(), Map.class);
                    }
                    throw new InvalidValueDeserializationException(parser, "More than one K,V pair with {__entity, __extn}: " + node.toString(), node.asToken(), Map.class);
                }
                CedarMap myMap = new CedarMap();
                iter = node.fields();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    myMap.put((String)entry.getKey(), (Value)mapper.treeToValue((TreeNode)entry.getValue(), Value.class));
                }
                return myMap;
            }
            throw new InvalidValueDeserializationException(parser, node.toString(), node.asToken(), Object.class);
        }
        catch (StackOverflowError e) {
            throw new DeserializationRecursionDepthException("Stack overflow while deserializing value. " + e.toString());
        }
    }

    private static enum EscapeType {
        ENTITY,
        EXTENSION,
        UNRECOGNIZED;

    }
}

