/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model.schema;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Objects;

public final class Schema {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @JsonValue
    private final JsonNode schemaJson;

    @SuppressFBWarnings
    public Schema(String schemaJson) throws IOException {
        if (schemaJson == null) {
            throw new NullPointerException("schemaJson");
        }
        this.schemaJson = OBJECT_MAPPER.readTree(schemaJson);
    }

    @SuppressFBWarnings
    public Schema(JsonNode schemaJson) {
        if (schemaJson == null) {
            throw new NullPointerException("schemaJson");
        }
        this.schemaJson = schemaJson;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)o;
        return this.schemaJson.equals((Object)other.schemaJson);
    }

    public int hashCode() {
        return Objects.hash(this.schemaJson);
    }

    public String toString() {
        return "Schema(schemaJson=" + this.schemaJson + ")";
    }
}

