/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model.slice;

import com.cedarpolicy.loader.LibraryLoader;
import com.cedarpolicy.model.exception.InternalException;
import com.cedarpolicy.value.EntityUID;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Policy {
    private static final Logger LOG = LoggerFactory.getLogger(Policy.class);
    private static final AtomicInteger idCounter = new AtomicInteger(0);
    public final String policySrc;
    public final String policyID;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public Policy(@JsonProperty(value="policySrc") String policy, @JsonProperty(value="policyID") String policyID) throws NullPointerException {
        if (policy == null) {
            throw new NullPointerException("Failed to construct policy from null string");
        }
        if (policyID == null) {
            policyID = "policy" + idCounter.addAndGet(1);
        }
        this.policySrc = policy;
        this.policyID = policyID;
    }

    public String toString() {
        return "// Policy ID: " + this.policyID + "\n" + this.policySrc;
    }

    public static Policy parseStaticPolicy(String policyStr) throws InternalException, NullPointerException {
        String policyText = Policy.parsePolicyJni(policyStr);
        return new Policy(policyText, null);
    }

    public static Policy parsePolicyTemplate(String templateStr) throws InternalException, NullPointerException {
        String templateText = Policy.parsePolicyTemplateJni(templateStr);
        return new Policy(templateText, null);
    }

    public static boolean validateTemplateLinkedPolicy(Policy p, EntityUID principal, EntityUID resource) throws InternalException, NullPointerException {
        return Policy.validateTemplateLinkedPolicyJni(p.policySrc, principal, resource);
    }

    private static native String parsePolicyJni(String var0) throws InternalException, NullPointerException;

    private static native String parsePolicyTemplateJni(String var0) throws InternalException, NullPointerException;

    private static native boolean validateTemplateLinkedPolicyJni(String var0, EntityUID var1, EntityUID var2) throws InternalException, NullPointerException;

    static {
        LibraryLoader.loadLibrary();
    }
}

