/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.value;

import com.cedarpolicy.loader.LibraryLoader;
import com.cedarpolicy.value.EntityIdentifier;
import com.cedarpolicy.value.EntityUID;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class EntityTypeName {
    private final List<String> namespace;
    private final String basename;
    private final Supplier<String> entityTypeNameRepr;

    protected EntityTypeName(List<String> namespace, String basename) {
        this.namespace = namespace;
        this.basename = basename;
        this.entityTypeNameRepr = Suppliers.memoize(() -> EntityTypeName.getEntityTypeNameRepr(this));
    }

    public EntityUID of(String id) {
        return new EntityUID(this, id);
    }

    public EntityUID of(EntityIdentifier id) {
        return new EntityUID(this, id);
    }

    public Stream<String> getNamespaceComponents() {
        return this.namespace.stream();
    }

    protected List<String> getNamespace() {
        return this.namespace;
    }

    public String getNamespaceAsString() {
        return this.namespace.stream().collect(Collectors.joining("::"));
    }

    public String toString() {
        return this.entityTypeNameRepr.get();
    }

    public String getBaseName() {
        return this.basename;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        try {
            EntityTypeName rhs_typename = (EntityTypeName)rhs;
            return this.basename.equals(rhs_typename.basename) && this.namespace.equals(rhs_typename.namespace);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return Objects.hash(this.basename, this.namespace);
    }

    public static Optional<EntityTypeName> parse(String src) {
        return EntityTypeName.parseEntityTypeName(src);
    }

    private static native Optional<EntityTypeName> parseEntityTypeName(String var0);

    private static native String getEntityTypeNameRepr(EntityTypeName var0);

    static {
        LibraryLoader.loadLibrary();
    }
}

