/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Set;

public final class AuthorizationResponse {
    private final Decision decision;
    private final Diagnostics diagnostics;

    @JsonCreator
    public AuthorizationResponse(@JsonProperty(value="response") InterfaceResponse response) {
        this.decision = response.decision;
        this.diagnostics = response.diagnostics;
    }

    public Decision getDecision() {
        return this.decision;
    }

    public Set<String> getReasons() {
        return this.diagnostics.reason;
    }

    public List<String> getErrors() {
        return this.diagnostics.errors;
    }

    public boolean isAllowed() {
        return this.decision == Decision.Allow;
    }

    public boolean reachedDecision() {
        return this.decision != Decision.NoDecision;
    }

    public static class InterfaceResponse {
        private final Decision decision;
        private final Diagnostics diagnostics;

        @SuppressFBWarnings
        public InterfaceResponse(@JsonProperty(value="decision") Decision decision, @JsonProperty(value="diagnostics") Diagnostics diagnostics) {
            this.decision = decision;
            this.diagnostics = diagnostics;
        }
    }

    public static enum Decision {
        Allow,
        Deny,
        NoDecision;

    }

    public static class Diagnostics {
        private ImmutableSet<String> reason;
        private ImmutableList<String> errors;

        @SuppressFBWarnings
        public Diagnostics(@JsonProperty(value="reason") Set<String> reason, @JsonProperty(value="errors") List<String> errors) {
            this.errors = ImmutableList.copyOf(errors);
            this.reason = ImmutableSet.copyOf(reason);
        }

        public Set<String> getReasons() {
            return this.reason;
        }

        public List<String> getErrors() {
            return this.errors;
        }
    }
}

