/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model.slice;

import com.cedarpolicy.model.slice.Entity;
import com.cedarpolicy.model.slice.Policy;
import com.cedarpolicy.model.slice.Slice;
import com.cedarpolicy.model.slice.TemplateInstantiation;
import com.cedarpolicy.value.Value;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BasicSlice
implements Slice {
    private final Map<String, String> policies = new HashMap<String, String>();
    private final Map<String, Map<String, Value>> attributes;
    private final Map<String, List<String>> parents;
    private final Set<Entity> entities;
    @JsonProperty(value="template_policies")
    private final Map<String, String> templatePolicies;
    @JsonProperty(value="template_instantiations")
    private final List<TemplateInstantiation> templateInstantiations;

    @SuppressFBWarnings
    public BasicSlice(Set<Policy> policies, Set<Entity> entities, Set<Policy> templates, List<TemplateInstantiation> templateInstantiations) {
        for (Policy p2 : policies) {
            this.policies.put(p2.policyID, p2.policySrc);
        }
        HashMap<String, Map<String, Value>> attributes = new HashMap<String, Map<String, Value>>();
        HashMap<String, List<String>> parents = new HashMap<String, List<String>>();
        for (Entity entity : entities) {
            attributes.put(entity.getEUID().toString(), entity.attrs);
            ArrayList parentList = new ArrayList(entity.getParents().stream().map(euid -> euid.toString()).collect(Collectors.toList()));
            parents.put(entity.getEUID().toString(), parentList);
        }
        this.attributes = attributes;
        this.parents = parents;
        this.entities = entities;
        this.templatePolicies = templates.stream().collect(Collectors.toMap(p -> p.policyID, p -> p.policySrc));
        this.templateInstantiations = new ArrayList<TemplateInstantiation>(templateInstantiations);
    }

    @SuppressFBWarnings
    public BasicSlice(Set<Policy> policies, Set<Entity> entities) {
        this(policies, entities, Collections.emptySet(), Collections.emptyList());
    }

    @Override
    @SuppressFBWarnings
    public Map<String, String> getPolicies() {
        return this.policies;
    }

    @Override
    @SuppressFBWarnings
    public Map<String, Map<String, Value>> getAttributes() {
        return this.attributes;
    }

    @Override
    @SuppressFBWarnings
    public Map<String, List<String>> getParents() {
        return this.parents;
    }

    @Override
    @SuppressFBWarnings
    public Set<Entity> getEntities() {
        return this.entities;
    }

    @Override
    @SuppressFBWarnings
    public Map<String, String> getTemplates() {
        return this.templatePolicies;
    }

    @Override
    @SuppressFBWarnings
    public List<TemplateInstantiation> getTemplateInstantiations() {
        return this.templateInstantiations;
    }

    public String toString() {
        return "BasicSlice{policies=" + this.policies + ", attributes=" + this.attributes + ", parents=" + this.parents + "}";
    }
}

