/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy;

import com.cedarpolicy.model.slice.Entity;
import com.cedarpolicy.model.slice.Slice;
import com.cedarpolicy.serializer.JsonEUID;
import com.cedarpolicy.value.Value;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class SliceJsonSerializer
extends JsonSerializer<Slice> {
    SliceJsonSerializer() {
    }

    public void serialize(Slice slice, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeObjectField("policies", slice.getPolicies());
        jsonGenerator.writeObjectField("entities", this.convertEntitiesToJsonEntities(slice.getEntities()));
        jsonGenerator.writeObjectField("templates", slice.getTemplates());
        jsonGenerator.writeObjectField("template_instantiations", slice.getTemplateInstantiations());
        jsonGenerator.writeEndObject();
    }

    Set<JsonEntity> convertEntitiesToJsonEntities(Set<Entity> entities) {
        HashSet<JsonEntity> ret = new HashSet<JsonEntity>();
        for (Entity entity : entities) {
            ret.add(new JsonEntity(entity));
        }
        return ret;
    }

    private static class JsonEntity {
        @SuppressFBWarnings
        public final JsonEUID uid;
        @SuppressFBWarnings
        public final Map<String, Value> attrs;
        public final Set<JsonEUID> parents;

        JsonEntity(Entity e) {
            this.uid = e.getEUID().asJson();
            this.attrs = e.attrs;
            this.parents = e.getParents().stream().map(euid -> euid.asJson()).collect(Collectors.toSet());
        }
    }
}

