/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model.slice;

import com.cedarpolicy.loader.LibraryLoader;
import com.cedarpolicy.model.exception.InternalException;
import com.cedarpolicy.model.slice.Policy;
import com.cedarpolicy.model.slice.TemplateInstantiation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class PolicySet {
    public Set<Policy> policies;
    public List<TemplateInstantiation> templateInstantiations;
    public Set<Policy> templates;

    public PolicySet() {
        this.policies = Collections.emptySet();
        this.templates = Collections.emptySet();
        this.templateInstantiations = Collections.emptyList();
    }

    public PolicySet(Set<Policy> policies) {
        this.policies = policies;
        this.templates = Collections.emptySet();
        this.templateInstantiations = Collections.emptyList();
    }

    public PolicySet(Set<Policy> policies, Set<Policy> templates) {
        this.policies = policies;
        this.templates = templates;
        this.templateInstantiations = Collections.emptyList();
    }

    public PolicySet(Set<Policy> policies, Set<Policy> templates, List<TemplateInstantiation> templateInstantiations) {
        this.policies = policies;
        this.templates = templates;
        this.templateInstantiations = templateInstantiations;
    }

    public static PolicySet parsePolicies(Path filePath) throws InternalException, IOException {
        String policiesString = Files.readString(filePath);
        return PolicySet.parsePolicies(policiesString);
    }

    public static PolicySet parsePolicies(String policiesString) throws InternalException {
        PolicySet policySet = PolicySet.parsePoliciesJni(policiesString);
        return policySet;
    }

    private static native PolicySet parsePoliciesJni(String var0) throws InternalException, NullPointerException;

    static {
        LibraryLoader.loadLibrary();
    }
}

