/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model.entity;

import com.cedarpolicy.value.EntityUID;
import com.cedarpolicy.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Entity {
    private final EntityUID euid;
    public final Map<String, Value> attrs;
    public final Set<EntityUID> parentsEUIDs;

    public Entity(EntityUID uid, Map<String, Value> attributes, Set<EntityUID> parentsEUIDs) {
        this.attrs = new HashMap<String, Value>(attributes);
        this.euid = uid;
        this.parentsEUIDs = parentsEUIDs;
    }

    public String toString() {
        Object parentStr = "";
        if (!this.parentsEUIDs.isEmpty()) {
            ArrayList parentStrs = new ArrayList(this.parentsEUIDs.stream().map(euid -> euid.toString()).collect(Collectors.toList()));
            parentStr = "\n\tparents:\n\t\t" + String.join((CharSequence)"\n\t\t", parentStrs);
        }
        Object attributeStr = "";
        if (!this.attrs.isEmpty()) {
            attributeStr = "\n\tattrs:\n\t\t" + this.attrs.entrySet().stream().map(e -> (String)e.getKey() + ": " + e.getValue()).collect(Collectors.joining("\n\t\t"));
        }
        return this.euid.toString() + (String)parentStr + (String)attributeStr;
    }

    public EntityUID getEUID() {
        return this.euid;
    }

    public Set<EntityUID> getParents() {
        return this.parentsEUIDs;
    }
}

