/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.cedarpolicy.Experimental;
import com.cedarpolicy.ExperimentalFeature;
import com.cedarpolicy.model.AuthorizationSuccessResponse;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;

@Experimental(value=ExperimentalFeature.PARTIAL_EVALUATION)
public class PartialAuthorizationResponse {
    private final AuthorizationSuccessResponse.Decision decision;
    private final ImmutableSet<String> satisfied;
    private final ImmutableSet<String> errored;
    private final ImmutableSet<String> mayBeDetermining;
    private final ImmutableSet<String> mustBeDetermining;
    private final ImmutableMap<String, JsonNode> residuals;
    private final ImmutableSet<String> nontrivialResiduals;
    private final ImmutableSet<String> warnings;

    public PartialAuthorizationResponse(AuthorizationSuccessResponse.Decision decision, Set<String> satisfied, Set<String> errored, Set<String> mayBeDetermining, Set<String> mustBeDetermining, Map<String, JsonNode> residuals, Set<String> nontrivialResiduals, Set<String> warnings) {
        this.decision = decision;
        this.satisfied = ImmutableSet.copyOf(satisfied);
        this.errored = ImmutableSet.copyOf(errored);
        this.mayBeDetermining = ImmutableSet.copyOf(mayBeDetermining);
        this.mustBeDetermining = ImmutableSet.copyOf(mustBeDetermining);
        this.residuals = ImmutableMap.copyOf(residuals);
        this.nontrivialResiduals = ImmutableSet.copyOf(nontrivialResiduals);
        this.warnings = warnings == null ? ImmutableSet.of() : ImmutableSet.copyOf(warnings);
    }

    public AuthorizationSuccessResponse.Decision getDecision() {
        return this.decision;
    }

    public Map<String, JsonNode> getResiduals() {
        return this.residuals;
    }

    public Set<String> getSatisfied() {
        return this.satisfied;
    }

    public Set<String> getErrored() {
        return this.errored;
    }

    public Set<String> getMayBeDetermining() {
        return this.mayBeDetermining;
    }

    public Set<String> getMustBeDetermining() {
        return this.mustBeDetermining;
    }

    public Set<String> getNontrivialResiduals() {
        return this.nontrivialResiduals;
    }

    @JsonCreator
    public static PartialAuthorizationResponse createPartialAuthorizationResponse(@JsonProperty(value="response") PartialAuthorizationResponse nested, @JsonProperty(value="decision") AuthorizationSuccessResponse.Decision decision, @JsonProperty(value="satisfied") Set<String> satisfied, @JsonProperty(value="errored") Set<String> errored, @JsonProperty(value="mayBeDetermining") Set<String> mayBeDetermining, @JsonProperty(value="mustBeDetermining") Set<String> mustBeDetermining, @JsonProperty(value="residuals") Map<String, JsonNode> residuals, @JsonProperty(value="nontrivialResiduals") Set<String> nontrivialResiduals, @JsonProperty(value="warnings") Set<String> warnings) {
        if (nested != null) {
            return nested;
        }
        return new PartialAuthorizationResponse(decision, satisfied, errored, mayBeDetermining, mustBeDetermining, residuals, nontrivialResiduals, warnings);
    }
}

