/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.cedarpolicy.model.DetailedError;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Set;

public final class AuthorizationSuccessResponse {
    private final Decision decision;
    private final Diagnostics diagnostics;

    @JsonCreator
    public AuthorizationSuccessResponse(@JsonProperty(value="decision") Decision decision, @JsonProperty(value="diagnostics") Diagnostics diagnostics) {
        this.decision = decision;
        this.diagnostics = diagnostics;
    }

    public Decision getDecision() {
        return this.decision;
    }

    public Set<String> getReason() {
        return this.diagnostics.reason;
    }

    public List<AuthorizationError> getErrors() {
        return this.diagnostics.errors;
    }

    public boolean isAllowed() {
        return this.decision == Decision.Allow;
    }

    public String toString() {
        return String.format("%s, reason %s, errors %s", new Object[]{this.decision, this.diagnostics.reason, this.diagnostics.errors});
    }

    public static enum Decision {
        Allow,
        Deny;

    }

    public static class Diagnostics {
        private ImmutableSet<String> reason;
        private ImmutableList<AuthorizationError> errors;

        @SuppressFBWarnings
        public Diagnostics(@JsonProperty(value="reason") Set<String> reason, @JsonProperty(value="errors") List<AuthorizationError> errors) {
            this.errors = ImmutableList.copyOf(errors);
            this.reason = ImmutableSet.copyOf(reason);
        }

        public Set<String> getReasons() {
            return this.reason;
        }

        public List<AuthorizationError> getErrors() {
            return this.errors;
        }
    }

    public static final class AuthorizationError {
        @JsonProperty(value="policyId")
        private final String policyId;
        @JsonProperty(value="error")
        private final DetailedError error;

        @JsonCreator
        public AuthorizationError(@JsonProperty(value="policyId") String policyId, @JsonProperty(value="error") DetailedError error) {
            this.policyId = policyId;
            this.error = error;
        }

        public String getPolicyId() {
            return this.policyId;
        }

        public DetailedError getError() {
            return this.error;
        }

        public String toString() {
            return String.format("AuthorizationError{policyId=%s, error=%s}", this.policyId, this.error);
        }
    }
}

