/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.value;

import com.cedarpolicy.value.Value;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class CedarMap
extends Value
implements Map<String, Value> {
    private final Map<String, Value> map;

    public CedarMap(Map<String, Value> source) {
        this.map = new HashMap<String, Value>(source);
    }

    public CedarMap() {
        this.map = new HashMap<String, Value>();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CedarMap map1 = (CedarMap)o;
        return this.map.equals(map1.map);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.map);
    }

    @Override
    public String toCedarExpr() {
        return "{" + this.map.entrySet().stream().map(e -> '\"' + (String)e.getKey() + "\": " + ((Value)e.getValue()).toCedarExpr()).collect(Collectors.joining(", ")) + "}";
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object k) {
        return this.map.containsKey(k);
    }

    @Override
    public boolean containsValue(Object v) {
        return this.map.containsValue(v);
    }

    @Override
    public Set<Map.Entry<String, Value>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Value get(Object k) {
        return this.map.get(k);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Value put(String k, Value v) throws NullPointerException {
        if (k == null) {
            throw new NullPointerException("Attempt to put null key in CedarMap");
        }
        if (v == null) {
            throw new NullPointerException("Attempt to put null value in CedarMap");
        }
        return this.map.put(k, v);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Value> m) {
        this.map.putAll(m);
    }

    @Override
    public Value remove(Object k) {
        return this.map.remove(k);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Value> values() {
        return this.map.values();
    }

    public String toString() {
        return this.map.toString();
    }
}

