/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.cedarpolicy.model.policy.PolicySet;
import com.cedarpolicy.model.schema.Schema;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;

public final class LevelValidationRequest {
    private final Schema schema;
    private final PolicySet policies;
    private final long maxDerefLevel;

    @SuppressFBWarnings
    public LevelValidationRequest(Schema schema, PolicySet policies, long maxDerefLevel) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (policies == null) {
            throw new NullPointerException("policies");
        }
        if (maxDerefLevel < 0L) {
            throw new IllegalArgumentException("maxDerefLevel must be non-negative");
        }
        this.schema = schema;
        this.policies = policies;
        this.maxDerefLevel = maxDerefLevel;
    }

    public Schema getSchema() {
        return this.schema;
    }

    @JsonProperty(value="policies")
    public PolicySet getPolicySet() {
        return this.policies;
    }

    public long getMaxDerefLevel() {
        return this.maxDerefLevel;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LevelValidationRequest)) {
            return false;
        }
        LevelValidationRequest other = (LevelValidationRequest)o;
        return this.schema.equals(other.schema) && this.policies.equals(other.policies) && this.maxDerefLevel == other.maxDerefLevel;
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.policies, this.maxDerefLevel);
    }

    public String toString() {
        return "ValidationRequest(schema=" + this.schema + ", policies=" + this.policies + ", maxDerefLevel=" + this.maxDerefLevel + ")";
    }
}

