/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model.policy;

import com.cedarpolicy.CedarJson;
import com.cedarpolicy.loader.LibraryLoader;
import com.cedarpolicy.model.exception.InternalException;
import com.cedarpolicy.model.policy.Policy;
import com.cedarpolicy.model.policy.TemplateLink;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PolicySet {
    public Set<Policy> policies;
    public List<TemplateLink> templateLinks;
    public Set<Policy> templates;

    public PolicySet() {
        this.policies = Collections.emptySet();
        this.templates = Collections.emptySet();
        this.templateLinks = Collections.emptyList();
    }

    public PolicySet(Set<Policy> policies) {
        this.policies = policies;
        this.templates = Collections.emptySet();
        this.templateLinks = Collections.emptyList();
    }

    public PolicySet(Set<Policy> policies, Set<Policy> templates) {
        this.policies = policies;
        this.templates = templates;
        this.templateLinks = Collections.emptyList();
    }

    public PolicySet(Set<Policy> policies, Set<Policy> templates, List<TemplateLink> templateLinks) {
        this.policies = policies;
        this.templates = templates;
        this.templateLinks = templateLinks;
    }

    public Map<String, String> getStaticPolicies() {
        return this.policies.stream().collect(Collectors.toMap(Policy::getID, Policy::getSource));
    }

    public Map<String, String> getTemplates() {
        return this.templates.stream().collect(Collectors.toMap(Policy::getID, Policy::getSource));
    }

    public int getNumPolicies() {
        return this.policies != null ? this.policies.size() : 0;
    }

    public int getNumTemplates() {
        return this.templates != null ? this.templates.size() : 0;
    }

    public String toJson() throws InternalException, JsonProcessingException {
        return PolicySet.policySetToJson(CedarJson.objectWriter().writeValueAsString((Object)this));
    }

    public static PolicySet parsePolicies(Path filePath) throws InternalException, IOException {
        String policiesString = Files.readString(filePath);
        return PolicySet.parsePolicies(policiesString);
    }

    public static PolicySet parsePolicies(String policiesString) throws InternalException {
        PolicySet policySet = PolicySet.parsePoliciesJni(policiesString);
        return policySet;
    }

    private static native PolicySet parsePoliciesJni(String var0) throws InternalException, NullPointerException;

    private static native String policySetToJson(String var0) throws InternalException, NullPointerException;

    static {
        LibraryLoader.loadLibrary();
    }
}

