/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.value;

import com.cedarpolicy.value.Value;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTime
extends Value {
    private final String dateTime;
    private final Instant parsedInstant;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public DateTime(String dateTime) throws NullPointerException, IllegalArgumentException {
        Optional parsed = DateTimeValidator.parseToInstant(dateTime);
        if (parsed.isEmpty()) {
            throw new IllegalArgumentException("Input string is not a supported DateTime format: " + dateTime);
        }
        this.dateTime = dateTime;
        this.parsedInstant = (Instant)parsed.get();
    }

    @Override
    public String toCedarExpr() {
        return "datetime(\"" + this.dateTime + "\")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTime other = (DateTime)o;
        return Objects.equals(this.parsedInstant, other.parsedInstant);
    }

    public int hashCode() {
        return Objects.hash(this.parsedInstant);
    }

    public String toString() {
        return this.dateTime;
    }

    public long toEpochMilli() {
        return this.parsedInstant.toEpochMilli();
    }

    private static class DateTimeValidator {
        private static final Pattern OFFSET_PATTERN = Pattern.compile("([+-])(\\d{2})(\\d{2})$");
        private static final List<DateTimeFormatter> UTC_FORMATTERS = Arrays.asList(DateTimeFormatter.ofPattern("uuuu-MM-dd").withResolverStyle(ResolverStyle.STRICT), DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ssX").withResolverStyle(ResolverStyle.STRICT), DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSSX").withResolverStyle(ResolverStyle.STRICT));
        private static final List<DateTimeFormatter> LOCAL_FORMATTERS = Arrays.asList(DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss").withResolverStyle(ResolverStyle.STRICT), DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSS").withResolverStyle(ResolverStyle.STRICT));
        private static final Instant MIN_INSTANT = Instant.ofEpochMilli(-62167305540000L);
        private static final Instant MAX_INSTANT = Instant.ofEpochMilli(253402387139000L);

        private DateTimeValidator() {
        }

        private static boolean isValidInstant(Instant instant) {
            return !instant.isBefore(MIN_INSTANT) && !instant.isAfter(MAX_INSTANT);
        }

        private static Optional<Instant> parseToInstant(String dateTimeString) {
            if (dateTimeString == null || dateTimeString.trim().isEmpty()) {
                return Optional.empty();
            }
            Matcher offsetMatcher = OFFSET_PATTERN.matcher(dateTimeString);
            Optional<Instant> result = offsetMatcher.find() ? DateTimeValidator.parseWithCustomOffset(dateTimeString, offsetMatcher) : UTC_FORMATTERS.stream().flatMap(formatter -> DateTimeValidator.tryParseUTCDateTime(dateTimeString, formatter).stream()).findFirst();
            if (result.isPresent() && !DateTimeValidator.isValidInstant(result.get())) {
                return Optional.empty();
            }
            return result;
        }

        private static Optional<Instant> parseWithCustomOffset(String dateTimeString, Matcher offsetMatcher) {
            try {
                String sign = offsetMatcher.group(1);
                int offsetHours = Integer.parseInt(offsetMatcher.group(2));
                int offsetMinutes = Integer.parseInt(offsetMatcher.group(3));
                if (offsetHours > 23 || offsetMinutes > 59) {
                    return Optional.empty();
                }
                String dateTimeWithoutOffset = dateTimeString.substring(0, offsetMatcher.start());
                Optional localDateTime = LOCAL_FORMATTERS.stream().flatMap(formatter -> DateTimeValidator.tryParseLocalDateTime(dateTimeWithoutOffset, formatter).stream()).findFirst();
                if (localDateTime.isEmpty()) {
                    return Optional.empty();
                }
                long epochMillis = ((LocalDateTime)localDateTime.get()).toInstant(ZoneOffset.UTC).toEpochMilli();
                long offsetMillis = DateTimeValidator.convertOffsetToMilliseconds(sign, offsetHours, offsetMinutes);
                long adjustedEpochMillis = epochMillis - offsetMillis;
                return Optional.of(Instant.ofEpochMilli(adjustedEpochMillis));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }

        private static Optional<LocalDateTime> tryParseLocalDateTime(String dateTimeString, DateTimeFormatter formatter) {
            try {
                return Optional.of(LocalDateTime.parse(dateTimeString, formatter));
            }
            catch (DateTimeParseException e) {
                return Optional.empty();
            }
        }

        private static Optional<Instant> tryParseUTCDateTime(String dateTimeString, DateTimeFormatter formatter) {
            try {
                if (formatter == UTC_FORMATTERS.get(0)) {
                    LocalDate date = LocalDate.parse(dateTimeString, formatter);
                    return Optional.of(date.atStartOfDay(ZoneOffset.UTC).toInstant());
                }
                if (!dateTimeString.endsWith("Z")) {
                    return Optional.empty();
                }
                OffsetDateTime dateTime = OffsetDateTime.parse(dateTimeString, formatter);
                return Optional.of(dateTime.toInstant());
            }
            catch (DateTimeParseException e) {
                return Optional.empty();
            }
        }

        private static long convertOffsetToMilliseconds(String sign, int hours, int minutes) {
            long totalMinutes = (long)hours * 60L + (long)minutes;
            long milliseconds = totalMinutes * 60L * 1000L;
            return "+".equals(sign) ? milliseconds : -milliseconds;
        }
    }
}

