/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.value;

import com.cedarpolicy.value.Value;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class Duration
extends Value
implements Comparable<Duration> {
    private final String durationString;
    private final long totalMilliseconds;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public Duration(String duration) throws NullPointerException, IllegalArgumentException {
        if (duration == null) {
            throw new NullPointerException("Duration string cannot be null");
        }
        try {
            this.totalMilliseconds = DurationValidator.parseToMilliseconds(duration);
            this.durationString = duration;
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("Duration value is too large and would cause overflow: " + duration, e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Input string is not a supported Duration format: " + duration, e);
        }
    }

    @Override
    public String toCedarExpr() {
        return "duration(\"" + this.durationString + "\")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration other = (Duration)o;
        return this.totalMilliseconds == other.totalMilliseconds;
    }

    public int hashCode() {
        return Objects.hash(this.totalMilliseconds);
    }

    public String toString() {
        return this.durationString;
    }

    @Override
    public int compareTo(Duration other) {
        if (other == null) {
            throw new NullPointerException("Cannot compare with null Duration");
        }
        return Long.compare(this.totalMilliseconds, other.totalMilliseconds);
    }

    @Generated
    public long getTotalMilliseconds() {
        return this.totalMilliseconds;
    }

    private static class DurationValidator {
        private static final Pattern DURATION_PATTERN = Pattern.compile("^(-?)(?:(?:(\\d+)d)?(?:(\\d+)h)?(?:(\\d+)m(?!s))?(?:(\\d+)s)?(?:(\\d+)ms)?)$");
        private static final long DAYS_TO_MS = 86400000L;
        private static final long HOURS_TO_MS = 3600000L;
        private static final long MINUTES_TO_MS = 60000L;
        private static final long SECONDS_TO_MS = 1000L;
        private static final long MILLISECONDS_TO_MS = 1L;

        private DurationValidator() {
        }

        private static long parseToMilliseconds(String durationString) throws IllegalArgumentException, ArithmeticException {
            String millisecondsStr;
            String secondsStr;
            String minutesStr;
            String hoursStr;
            if (durationString == null || durationString.trim().isEmpty()) {
                throw new IllegalArgumentException("Duration string cannot be null or empty");
            }
            Matcher matcher = DURATION_PATTERN.matcher(durationString);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid duration format");
            }
            String sign = matcher.group(1);
            long totalMs = 0L;
            boolean hasAnyComponent = false;
            String daysStr = matcher.group(2);
            if (daysStr != null && !daysStr.isEmpty()) {
                long days = Long.parseLong(sign + daysStr);
                totalMs = Math.addExact(totalMs, Math.multiplyExact(days, 86400000L));
                hasAnyComponent = true;
            }
            if ((hoursStr = matcher.group(3)) != null && !hoursStr.isEmpty()) {
                long hours = Long.parseLong(sign + hoursStr);
                totalMs = Math.addExact(totalMs, Math.multiplyExact(hours, 3600000L));
                hasAnyComponent = true;
            }
            if ((minutesStr = matcher.group(4)) != null && !minutesStr.isEmpty()) {
                long minutes = Long.parseLong(sign + minutesStr);
                totalMs = Math.addExact(totalMs, Math.multiplyExact(minutes, 60000L));
                hasAnyComponent = true;
            }
            if ((secondsStr = matcher.group(5)) != null && !secondsStr.isEmpty()) {
                long seconds = Long.parseLong(sign + secondsStr);
                totalMs = Math.addExact(totalMs, Math.multiplyExact(seconds, 1000L));
                hasAnyComponent = true;
            }
            if ((millisecondsStr = matcher.group(6)) != null && !millisecondsStr.isEmpty()) {
                long milliseconds = Long.parseLong(sign + millisecondsStr);
                totalMs = Math.addExact(totalMs, Math.multiplyExact(milliseconds, 1L));
                hasAnyComponent = true;
            }
            if (!hasAnyComponent) {
                throw new IllegalArgumentException("Invalid duration format");
            }
            return totalMs;
        }
    }
}

