/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The information you can supply when triggering a pipeline.")
public class TriggerPipelineParameters {
    public static final String JSON_PROPERTY_BRANCH = "branch";
    @JsonProperty(value="branch")
    private String branch;
    public static final String JSON_PROPERTY_TAG = "tag";
    @JsonProperty(value="tag")
    private String tag;
    public static final String JSON_PROPERTY_PARAMETERS = "parameters";
    @JsonProperty(value="parameters")
    private Object parameters = null;

    public TriggerPipelineParameters branch(String branch) {
        this.branch = branch;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="feature/design-new-api", value="The branch where the pipeline ran. The HEAD commit on this branch was used for the pipeline. Note that `branch` and `tag` are mutually exclusive.")
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public TriggerPipelineParameters tag(String tag) {
        this.tag = tag;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="v3.1.4159", value="The tag used by the pipeline. The commit that this tag points to was used for the pipeline. Note that `branch` and `tag` are mutually exclusive.")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public TriggerPipelineParameters parameters(Object parameters) {
        this.parameters = parameters;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"deploy_prod\":true}", value="An object containing pipeline parameters and their values.")
    public Object getParameters() {
        return this.parameters;
    }

    public void setParameters(Object parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerPipelineParameters triggerPipelineParameters = (TriggerPipelineParameters)o;
        return Objects.equals(this.branch, triggerPipelineParameters.branch) && Objects.equals(this.tag, triggerPipelineParameters.tag) && Objects.equals(this.parameters, triggerPipelineParameters.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.branch, this.tag, this.parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TriggerPipelineParameters {\n");
        sb.append("    branch: ").append(this.toIndentedString(this.branch)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

