/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.api;

import com.circleci.client.v2.ApiClient;
import com.circleci.client.v2.ApiException;
import com.circleci.client.v2.ApiResponse;
import com.circleci.client.v2.Configuration;
import com.circleci.client.v2.Pair;
import com.circleci.client.v2.model.ArtifactListResponse;
import com.circleci.client.v2.model.CheckoutKey;
import com.circleci.client.v2.model.CheckoutKeyInput;
import com.circleci.client.v2.model.CheckoutKeyListResponse;
import com.circleci.client.v2.model.Collaboration;
import com.circleci.client.v2.model.EnvironmentVariableListResponse;
import com.circleci.client.v2.model.EnvironmentVariablePair;
import com.circleci.client.v2.model.EnvironmentVariablePair1;
import com.circleci.client.v2.model.JobDetails;
import com.circleci.client.v2.model.MessageResponse;
import com.circleci.client.v2.model.PipelineConfig;
import com.circleci.client.v2.model.PipelineLight;
import com.circleci.client.v2.model.PipelineListResponse;
import com.circleci.client.v2.model.PipelineWithWorkflows;
import com.circleci.client.v2.model.Project;
import com.circleci.client.v2.model.RerunWorkflowParameters;
import com.circleci.client.v2.model.TestsResponse;
import com.circleci.client.v2.model.TriggerPipelineParameters;
import com.circleci.client.v2.model.User;
import com.circleci.client.v2.model.Workflow;
import com.circleci.client.v2.model.WorkflowJobListResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.GenericType;

public class DefaultApi {
    private ApiClient apiClient;

    public DefaultApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DefaultApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public MessageResponse cancelJob(Object jobNumber, String projectSlug) throws ApiException {
        return this.cancelJobWithHttpInfo(jobNumber, projectSlug).getData();
    }

    public ApiResponse<MessageResponse> cancelJobWithHttpInfo(Object jobNumber, String projectSlug) throws ApiException {
        Object localVarPostBody = new Object();
        if (jobNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'jobNumber' when calling cancelJob");
        }
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling cancelJob");
        }
        String localVarPath = "/project/{project-slug}/job/{job-number}/cancel".replaceAll("\\{job-number\\}", this.apiClient.escapeString(jobNumber.toString())).replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<MessageResponse> localVarReturnType = new GenericType<MessageResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MessageResponse cancelWorkflow(UUID id) throws ApiException {
        return this.cancelWorkflowWithHttpInfo(id).getData();
    }

    public ApiResponse<MessageResponse> cancelWorkflowWithHttpInfo(UUID id) throws ApiException {
        Object localVarPostBody = new Object();
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling cancelWorkflow");
        }
        String localVarPath = "/workflow/{id}/cancel".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<MessageResponse> localVarReturnType = new GenericType<MessageResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CheckoutKey createCheckoutKey(String projectSlug, CheckoutKeyInput checkoutKeyInput) throws ApiException {
        return this.createCheckoutKeyWithHttpInfo(projectSlug, checkoutKeyInput).getData();
    }

    public ApiResponse<CheckoutKey> createCheckoutKeyWithHttpInfo(String projectSlug, CheckoutKeyInput checkoutKeyInput) throws ApiException {
        CheckoutKeyInput localVarPostBody = checkoutKeyInput;
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling createCheckoutKey");
        }
        String localVarPath = "/project/{project-slug}/checkout-key".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<CheckoutKey> localVarReturnType = new GenericType<CheckoutKey>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvironmentVariablePair createEnvVar(String projectSlug, EnvironmentVariablePair1 environmentVariablePair1) throws ApiException {
        return this.createEnvVarWithHttpInfo(projectSlug, environmentVariablePair1).getData();
    }

    public ApiResponse<EnvironmentVariablePair> createEnvVarWithHttpInfo(String projectSlug, EnvironmentVariablePair1 environmentVariablePair1) throws ApiException {
        EnvironmentVariablePair1 localVarPostBody = environmentVariablePair1;
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling createEnvVar");
        }
        String localVarPath = "/project/{project-slug}/envvar".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<EnvironmentVariablePair> localVarReturnType = new GenericType<EnvironmentVariablePair>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MessageResponse deleteCheckoutKey(String projectSlug, String fingerprint) throws ApiException {
        return this.deleteCheckoutKeyWithHttpInfo(projectSlug, fingerprint).getData();
    }

    public ApiResponse<MessageResponse> deleteCheckoutKeyWithHttpInfo(String projectSlug, String fingerprint) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling deleteCheckoutKey");
        }
        if (fingerprint == null) {
            throw new ApiException(400, "Missing the required parameter 'fingerprint' when calling deleteCheckoutKey");
        }
        String localVarPath = "/project/{project-slug}/checkout-key/{fingerprint}".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString())).replaceAll("\\{fingerprint\\}", this.apiClient.escapeString(fingerprint.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<MessageResponse> localVarReturnType = new GenericType<MessageResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MessageResponse deleteEnvVar(String projectSlug, String name) throws ApiException {
        return this.deleteEnvVarWithHttpInfo(projectSlug, name).getData();
    }

    public ApiResponse<MessageResponse> deleteEnvVarWithHttpInfo(String projectSlug, String name) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling deleteEnvVar");
        }
        if (name == null) {
            throw new ApiException(400, "Missing the required parameter 'name' when calling deleteEnvVar");
        }
        String localVarPath = "/project/{project-slug}/envvar/{name}".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<MessageResponse> localVarReturnType = new GenericType<MessageResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CheckoutKey getCheckoutKey(String projectSlug, String fingerprint) throws ApiException {
        return this.getCheckoutKeyWithHttpInfo(projectSlug, fingerprint).getData();
    }

    public ApiResponse<CheckoutKey> getCheckoutKeyWithHttpInfo(String projectSlug, String fingerprint) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling getCheckoutKey");
        }
        if (fingerprint == null) {
            throw new ApiException(400, "Missing the required parameter 'fingerprint' when calling getCheckoutKey");
        }
        String localVarPath = "/project/{project-slug}/checkout-key/{fingerprint}".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString())).replaceAll("\\{fingerprint\\}", this.apiClient.escapeString(fingerprint.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<CheckoutKey> localVarReturnType = new GenericType<CheckoutKey>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Collaboration> getCollaborations() throws ApiException {
        return this.getCollaborationsWithHttpInfo().getData();
    }

    public ApiResponse<List<Collaboration>> getCollaborationsWithHttpInfo() throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/me/collaborations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<List<Collaboration>> localVarReturnType = new GenericType<List<Collaboration>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public User getCurrentUser() throws ApiException {
        return this.getCurrentUserWithHttpInfo().getData();
    }

    public ApiResponse<User> getCurrentUserWithHttpInfo() throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/me";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<User> localVarReturnType = new GenericType<User>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvironmentVariablePair getEnvVar(String projectSlug, String name) throws ApiException {
        return this.getEnvVarWithHttpInfo(projectSlug, name).getData();
    }

    public ApiResponse<EnvironmentVariablePair> getEnvVarWithHttpInfo(String projectSlug, String name) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling getEnvVar");
        }
        if (name == null) {
            throw new ApiException(400, "Missing the required parameter 'name' when calling getEnvVar");
        }
        String localVarPath = "/project/{project-slug}/envvar/{name}".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<EnvironmentVariablePair> localVarReturnType = new GenericType<EnvironmentVariablePair>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ArtifactListResponse getJobArtifacts(Object jobNumber, String projectSlug) throws ApiException {
        return this.getJobArtifactsWithHttpInfo(jobNumber, projectSlug).getData();
    }

    public ApiResponse<ArtifactListResponse> getJobArtifactsWithHttpInfo(Object jobNumber, String projectSlug) throws ApiException {
        Object localVarPostBody = new Object();
        if (jobNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'jobNumber' when calling getJobArtifacts");
        }
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling getJobArtifacts");
        }
        String localVarPath = "/project/{project-slug}/{job-number}/artifacts".replaceAll("\\{job-number\\}", this.apiClient.escapeString(jobNumber.toString())).replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<ArtifactListResponse> localVarReturnType = new GenericType<ArtifactListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public JobDetails getJobDetails(Object jobNumber, String projectSlug) throws ApiException {
        return this.getJobDetailsWithHttpInfo(jobNumber, projectSlug).getData();
    }

    public ApiResponse<JobDetails> getJobDetailsWithHttpInfo(Object jobNumber, String projectSlug) throws ApiException {
        Object localVarPostBody = new Object();
        if (jobNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'jobNumber' when calling getJobDetails");
        }
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling getJobDetails");
        }
        String localVarPath = "/project/{project-slug}/job/{job-number}".replaceAll("\\{job-number\\}", this.apiClient.escapeString(jobNumber.toString())).replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<JobDetails> localVarReturnType = new GenericType<JobDetails>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PipelineWithWorkflows getPipelineById(UUID pipelineId) throws ApiException {
        return this.getPipelineByIdWithHttpInfo(pipelineId).getData();
    }

    public ApiResponse<PipelineWithWorkflows> getPipelineByIdWithHttpInfo(UUID pipelineId) throws ApiException {
        Object localVarPostBody = new Object();
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling getPipelineById");
        }
        String localVarPath = "/pipeline/{pipeline-id}".replaceAll("\\{pipeline-id\\}", this.apiClient.escapeString(pipelineId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<PipelineWithWorkflows> localVarReturnType = new GenericType<PipelineWithWorkflows>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PipelineConfig getPipelineConfigById(UUID pipelineId) throws ApiException {
        return this.getPipelineConfigByIdWithHttpInfo(pipelineId).getData();
    }

    public ApiResponse<PipelineConfig> getPipelineConfigByIdWithHttpInfo(UUID pipelineId) throws ApiException {
        Object localVarPostBody = new Object();
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling getPipelineConfigById");
        }
        String localVarPath = "/pipeline/{pipeline-id}/config".replaceAll("\\{pipeline-id\\}", this.apiClient.escapeString(pipelineId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<PipelineConfig> localVarReturnType = new GenericType<PipelineConfig>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Project getProjectBySlug(String projectSlug) throws ApiException {
        return this.getProjectBySlugWithHttpInfo(projectSlug).getData();
    }

    public ApiResponse<Project> getProjectBySlugWithHttpInfo(String projectSlug) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling getProjectBySlug");
        }
        String localVarPath = "/project/{project-slug}".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<Project> localVarReturnType = new GenericType<Project>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TestsResponse getTests(Object jobNumber, String projectSlug) throws ApiException {
        return this.getTestsWithHttpInfo(jobNumber, projectSlug).getData();
    }

    public ApiResponse<TestsResponse> getTestsWithHttpInfo(Object jobNumber, String projectSlug) throws ApiException {
        Object localVarPostBody = new Object();
        if (jobNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'jobNumber' when calling getTests");
        }
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling getTests");
        }
        String localVarPath = "/project/{project-slug}/{job-number}/tests".replaceAll("\\{job-number\\}", this.apiClient.escapeString(jobNumber.toString())).replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<TestsResponse> localVarReturnType = new GenericType<TestsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Workflow getWorkflowById(UUID id) throws ApiException {
        return this.getWorkflowByIdWithHttpInfo(id).getData();
    }

    public ApiResponse<Workflow> getWorkflowByIdWithHttpInfo(UUID id) throws ApiException {
        Object localVarPostBody = new Object();
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getWorkflowById");
        }
        String localVarPath = "/workflow/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<Workflow> localVarReturnType = new GenericType<Workflow>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CheckoutKeyListResponse listCheckoutKeys(String projectSlug) throws ApiException {
        return this.listCheckoutKeysWithHttpInfo(projectSlug).getData();
    }

    public ApiResponse<CheckoutKeyListResponse> listCheckoutKeysWithHttpInfo(String projectSlug) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling listCheckoutKeys");
        }
        String localVarPath = "/project/{project-slug}/checkout-key".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<CheckoutKeyListResponse> localVarReturnType = new GenericType<CheckoutKeyListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvironmentVariableListResponse listEnvVars(String projectSlug) throws ApiException {
        return this.listEnvVarsWithHttpInfo(projectSlug).getData();
    }

    public ApiResponse<EnvironmentVariableListResponse> listEnvVarsWithHttpInfo(String projectSlug) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling listEnvVars");
        }
        String localVarPath = "/project/{project-slug}/envvar".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<EnvironmentVariableListResponse> localVarReturnType = new GenericType<EnvironmentVariableListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PipelineListResponse listMyPipelines(String projectSlug, String pageToken) throws ApiException {
        return this.listMyPipelinesWithHttpInfo(projectSlug, pageToken).getData();
    }

    public ApiResponse<PipelineListResponse> listMyPipelinesWithHttpInfo(String projectSlug, String pageToken) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling listMyPipelines");
        }
        String localVarPath = "/project/{project-slug}/pipeline/mine".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page-token", pageToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<PipelineListResponse> localVarReturnType = new GenericType<PipelineListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PipelineListResponse listPipelinesForProject(String projectSlug, String branch, String pageToken) throws ApiException {
        return this.listPipelinesForProjectWithHttpInfo(projectSlug, branch, pageToken).getData();
    }

    public ApiResponse<PipelineListResponse> listPipelinesForProjectWithHttpInfo(String projectSlug, String branch, String pageToken) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling listPipelinesForProject");
        }
        String localVarPath = "/project/{project-slug}/pipeline".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "branch", branch));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page-token", pageToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<PipelineListResponse> localVarReturnType = new GenericType<PipelineListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public WorkflowJobListResponse listWorkflowJobs(UUID id) throws ApiException {
        return this.listWorkflowJobsWithHttpInfo(id).getData();
    }

    public ApiResponse<WorkflowJobListResponse> listWorkflowJobsWithHttpInfo(UUID id) throws ApiException {
        Object localVarPostBody = new Object();
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling listWorkflowJobs");
        }
        String localVarPath = "/workflow/{id}/job".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<WorkflowJobListResponse> localVarReturnType = new GenericType<WorkflowJobListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MessageResponse rerunWorkflow(UUID id, RerunWorkflowParameters rerunWorkflowParameters) throws ApiException {
        return this.rerunWorkflowWithHttpInfo(id, rerunWorkflowParameters).getData();
    }

    public ApiResponse<MessageResponse> rerunWorkflowWithHttpInfo(UUID id, RerunWorkflowParameters rerunWorkflowParameters) throws ApiException {
        RerunWorkflowParameters localVarPostBody = rerunWorkflowParameters;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling rerunWorkflow");
        }
        String localVarPath = "/workflow/{id}/rerun".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<MessageResponse> localVarReturnType = new GenericType<MessageResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PipelineLight triggerPipeline(String projectSlug, TriggerPipelineParameters triggerPipelineParameters) throws ApiException {
        return this.triggerPipelineWithHttpInfo(projectSlug, triggerPipelineParameters).getData();
    }

    public ApiResponse<PipelineLight> triggerPipelineWithHttpInfo(String projectSlug, TriggerPipelineParameters triggerPipelineParameters) throws ApiException {
        TriggerPipelineParameters localVarPostBody = triggerPipelineParameters;
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling triggerPipeline");
        }
        String localVarPath = "/project/{project-slug}/pipeline".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<PipelineLight> localVarReturnType = new GenericType<PipelineLight>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

