/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The configuration strings for the pipeline.")
public class PipelineConfig {
    public static final String JSON_PROPERTY_SOURCE = "source";
    @JsonProperty(value="source")
    private String source;
    public static final String JSON_PROPERTY_COMPILED = "compiled";
    @JsonProperty(value="compiled")
    private String compiled;

    public PipelineConfig source(String source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(required=true, value="The source configuration for the pipeline, before any config compilation has been performed. If there is no config, then this field will be empty.")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public PipelineConfig compiled(String compiled) {
        this.compiled = compiled;
        return this;
    }

    @ApiModelProperty(required=true, value="The compiled configuration for the pipeline, after all orb expansion has been performed. If there were errors processing the pipeline's configuration, then this field may be empty.")
    public String getCompiled() {
        return this.compiled;
    }

    public void setCompiled(String compiled) {
        this.compiled = compiled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineConfig pipelineConfig = (PipelineConfig)o;
        return Objects.equals(this.source, pipelineConfig.source) && Objects.equals(this.compiled, pipelineConfig.compiled);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.compiled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PipelineConfig {\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    compiled: ").append(this.toIndentedString(this.compiled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

