/*
 * CircleCI API
 * This describes the resources that make up the CircleCI API v2. API v2 is currently in Preview. Additional documentation for this API can be found in the [API Preview Docs](https://github.com/CircleCI-Public/api-preview-docs/tree/master/docs). Breaking changes to the API will be announced in the [Breaking Changes log](https://github.com/CircleCI-Public/api-preview-docs/blob/master/docs/breaking.md).
 *
 * The version of the OpenAPI document: v2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.circleci.client.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.circleci.client.v2.model.InlineResponse200Metrics;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;

/**
 * InlineResponse200Items
 */

public class InlineResponse200Items {
  public static final String JSON_PROPERTY_NAME = "name";
  @JsonProperty(JSON_PROPERTY_NAME)
  private String name;

  public static final String JSON_PROPERTY_WINDOW_START = "window_start";
  @JsonProperty(JSON_PROPERTY_WINDOW_START)
  private OffsetDateTime windowStart;

  public static final String JSON_PROPERTY_WINDOW_END = "window_end";
  @JsonProperty(JSON_PROPERTY_WINDOW_END)
  private OffsetDateTime windowEnd;

  public static final String JSON_PROPERTY_METRICS = "metrics";
  @JsonProperty(JSON_PROPERTY_METRICS)
  private InlineResponse200Metrics metrics = null;

  public InlineResponse200Items name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the workflow.
   * @return name
  **/
  @ApiModelProperty(example = "build-and-test", required = true, value = "The name of the workflow.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public InlineResponse200Items windowStart(OffsetDateTime windowStart) {
    this.windowStart = windowStart;
    return this;
  }

   /**
   * The start of the aggregation window for workflow metrics.
   * @return windowStart
  **/
  @ApiModelProperty(required = true, value = "The start of the aggregation window for workflow metrics.")
  public OffsetDateTime getWindowStart() {
    return windowStart;
  }

  public void setWindowStart(OffsetDateTime windowStart) {
    this.windowStart = windowStart;
  }

  public InlineResponse200Items windowEnd(OffsetDateTime windowEnd) {
    this.windowEnd = windowEnd;
    return this;
  }

   /**
   * The end of the aggregation window for workflow metrics.
   * @return windowEnd
  **/
  @ApiModelProperty(required = true, value = "The end of the aggregation window for workflow metrics.")
  public OffsetDateTime getWindowEnd() {
    return windowEnd;
  }

  public void setWindowEnd(OffsetDateTime windowEnd) {
    this.windowEnd = windowEnd;
  }

  public InlineResponse200Items metrics(InlineResponse200Metrics metrics) {
    this.metrics = metrics;
    return this;
  }

   /**
   * Get metrics
   * @return metrics
  **/
  @ApiModelProperty(required = true, value = "")
  public InlineResponse200Metrics getMetrics() {
    return metrics;
  }

  public void setMetrics(InlineResponse200Metrics metrics) {
    this.metrics = metrics;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InlineResponse200Items inlineResponse200Items = (InlineResponse200Items) o;
    return Objects.equals(this.name, inlineResponse200Items.name) &&
        Objects.equals(this.windowStart, inlineResponse200Items.windowStart) &&
        Objects.equals(this.windowEnd, inlineResponse200Items.windowEnd) &&
        Objects.equals(this.metrics, inlineResponse200Items.metrics);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, windowStart, windowEnd, metrics);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InlineResponse200Items {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    windowStart: ").append(toIndentedString(windowStart)).append("\n");
    sb.append("    windowEnd: ").append(toIndentedString(windowEnd)).append("\n");
    sb.append("    metrics: ").append(toIndentedString(metrics)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

