/*
 * CircleCI API
 * This describes the resources that make up the CircleCI API v2. API v2 is currently in Preview. Additional documentation for this API can be found in the [API Preview Docs](https://github.com/CircleCI-Public/api-preview-docs/tree/master/docs). Breaking changes to the API will be announced in the [Breaking Changes log](https://github.com/CircleCI-Public/api-preview-docs/blob/master/docs/breaking.md).
 *
 * The version of the OpenAPI document: v2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.circleci.client.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.circleci.client.v2.model.InlineResponse200MetricsDurationMetrics;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Metrics relating to a workflow&#39;s runs.
 */
@ApiModel(description = "Metrics relating to a workflow's runs.")

public class InlineResponse200Metrics {
  public static final String JSON_PROPERTY_SUCCESS_RATE = "success_rate";
  @JsonProperty(JSON_PROPERTY_SUCCESS_RATE)
  private Float successRate;

  public static final String JSON_PROPERTY_TOTAL_RUNS = "total_runs";
  @JsonProperty(JSON_PROPERTY_TOTAL_RUNS)
  private Long totalRuns;

  public static final String JSON_PROPERTY_FAILED_RUNS = "failed_runs";
  @JsonProperty(JSON_PROPERTY_FAILED_RUNS)
  private Long failedRuns;

  public static final String JSON_PROPERTY_SUCCESSFUL_RUNS = "successful_runs";
  @JsonProperty(JSON_PROPERTY_SUCCESSFUL_RUNS)
  private Long successfulRuns;

  public static final String JSON_PROPERTY_THROUGHPUT = "throughput";
  @JsonProperty(JSON_PROPERTY_THROUGHPUT)
  private Float throughput;

  public static final String JSON_PROPERTY_MTTR = "mttr";
  @JsonProperty(JSON_PROPERTY_MTTR)
  private Long mttr;

  public static final String JSON_PROPERTY_TOTAL_CREDITS_USED = "total_credits_used";
  @JsonProperty(JSON_PROPERTY_TOTAL_CREDITS_USED)
  private Long totalCreditsUsed;

  public static final String JSON_PROPERTY_DURATION_METRICS = "duration_metrics";
  @JsonProperty(JSON_PROPERTY_DURATION_METRICS)
  private InlineResponse200MetricsDurationMetrics durationMetrics = null;

  public InlineResponse200Metrics successRate(Float successRate) {
    this.successRate = successRate;
    return this;
  }

   /**
   * The ratio of successful runs / total runs.
   * @return successRate
  **/
  @ApiModelProperty(required = true, value = "The ratio of successful runs / total runs.")
  public Float getSuccessRate() {
    return successRate;
  }

  public void setSuccessRate(Float successRate) {
    this.successRate = successRate;
  }

  public InlineResponse200Metrics totalRuns(Long totalRuns) {
    this.totalRuns = totalRuns;
    return this;
  }

   /**
   * The total number of runs.
   * minimum: 0
   * @return totalRuns
  **/
  @ApiModelProperty(required = true, value = "The total number of runs.")
  public Long getTotalRuns() {
    return totalRuns;
  }

  public void setTotalRuns(Long totalRuns) {
    this.totalRuns = totalRuns;
  }

  public InlineResponse200Metrics failedRuns(Long failedRuns) {
    this.failedRuns = failedRuns;
    return this;
  }

   /**
   * The number of failed runs.
   * minimum: 0
   * @return failedRuns
  **/
  @ApiModelProperty(required = true, value = "The number of failed runs.")
  public Long getFailedRuns() {
    return failedRuns;
  }

  public void setFailedRuns(Long failedRuns) {
    this.failedRuns = failedRuns;
  }

  public InlineResponse200Metrics successfulRuns(Long successfulRuns) {
    this.successfulRuns = successfulRuns;
    return this;
  }

   /**
   * The number of successful runs.
   * minimum: 0
   * @return successfulRuns
  **/
  @ApiModelProperty(required = true, value = "The number of successful runs.")
  public Long getSuccessfulRuns() {
    return successfulRuns;
  }

  public void setSuccessfulRuns(Long successfulRuns) {
    this.successfulRuns = successfulRuns;
  }

  public InlineResponse200Metrics throughput(Float throughput) {
    this.throughput = throughput;
    return this;
  }

   /**
   * The average number of workflow runs per day.
   * @return throughput
  **/
  @ApiModelProperty(required = true, value = "The average number of workflow runs per day.")
  public Float getThroughput() {
    return throughput;
  }

  public void setThroughput(Float throughput) {
    this.throughput = throughput;
  }

  public InlineResponse200Metrics mttr(Long mttr) {
    this.mttr = mttr;
    return this;
  }

   /**
   * The mean time to recovery (mean time between failures and their next success) in seconds.
   * minimum: 0
   * @return mttr
  **/
  @ApiModelProperty(required = true, value = "The mean time to recovery (mean time between failures and their next success) in seconds.")
  public Long getMttr() {
    return mttr;
  }

  public void setMttr(Long mttr) {
    this.mttr = mttr;
  }

  public InlineResponse200Metrics totalCreditsUsed(Long totalCreditsUsed) {
    this.totalCreditsUsed = totalCreditsUsed;
    return this;
  }

   /**
   * The total credits consumed by the workflow in the aggregation window.
   * minimum: 0
   * @return totalCreditsUsed
  **/
  @ApiModelProperty(required = true, value = "The total credits consumed by the workflow in the aggregation window.")
  public Long getTotalCreditsUsed() {
    return totalCreditsUsed;
  }

  public void setTotalCreditsUsed(Long totalCreditsUsed) {
    this.totalCreditsUsed = totalCreditsUsed;
  }

  public InlineResponse200Metrics durationMetrics(InlineResponse200MetricsDurationMetrics durationMetrics) {
    this.durationMetrics = durationMetrics;
    return this;
  }

   /**
   * Get durationMetrics
   * @return durationMetrics
  **/
  @ApiModelProperty(required = true, value = "")
  public InlineResponse200MetricsDurationMetrics getDurationMetrics() {
    return durationMetrics;
  }

  public void setDurationMetrics(InlineResponse200MetricsDurationMetrics durationMetrics) {
    this.durationMetrics = durationMetrics;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InlineResponse200Metrics inlineResponse200Metrics = (InlineResponse200Metrics) o;
    return Objects.equals(this.successRate, inlineResponse200Metrics.successRate) &&
        Objects.equals(this.totalRuns, inlineResponse200Metrics.totalRuns) &&
        Objects.equals(this.failedRuns, inlineResponse200Metrics.failedRuns) &&
        Objects.equals(this.successfulRuns, inlineResponse200Metrics.successfulRuns) &&
        Objects.equals(this.throughput, inlineResponse200Metrics.throughput) &&
        Objects.equals(this.mttr, inlineResponse200Metrics.mttr) &&
        Objects.equals(this.totalCreditsUsed, inlineResponse200Metrics.totalCreditsUsed) &&
        Objects.equals(this.durationMetrics, inlineResponse200Metrics.durationMetrics);
  }

  @Override
  public int hashCode() {
    return Objects.hash(successRate, totalRuns, failedRuns, successfulRuns, throughput, mttr, totalCreditsUsed, durationMetrics);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InlineResponse200Metrics {\n");
    sb.append("    successRate: ").append(toIndentedString(successRate)).append("\n");
    sb.append("    totalRuns: ").append(toIndentedString(totalRuns)).append("\n");
    sb.append("    failedRuns: ").append(toIndentedString(failedRuns)).append("\n");
    sb.append("    successfulRuns: ").append(toIndentedString(successfulRuns)).append("\n");
    sb.append("    throughput: ").append(toIndentedString(throughput)).append("\n");
    sb.append("    mttr: ").append(toIndentedString(mttr)).append("\n");
    sb.append("    totalCreditsUsed: ").append(toIndentedString(totalCreditsUsed)).append("\n");
    sb.append("    durationMetrics: ").append(toIndentedString(durationMetrics)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

