/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.model;

import com.circleci.client.v2.model.PipelineErrors;
import com.circleci.client.v2.model.PipelineTrigger;
import com.circleci.client.v2.model.PipelineVcs;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@ApiModel(description="NOTE: The definition of pipeline is subject to change.")
public class Pipeline {
    public static final String JSON_PROPERTY_ID = "id";
    @JsonProperty(value="id")
    private UUID id;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    @JsonProperty(value="errors")
    private List<PipelineErrors> errors = new ArrayList<PipelineErrors>();
    public static final String JSON_PROPERTY_PROJECT_SLUG = "project_slug";
    @JsonProperty(value="project_slug")
    private String projectSlug;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    @JsonProperty(value="updated_at")
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_NUMBER = "number";
    @JsonProperty(value="number")
    private Long number;
    public static final String JSON_PROPERTY_STATE = "state";
    @JsonProperty(value="state")
    private StateEnum state;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    @JsonProperty(value="created_at")
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_TRIGGER = "trigger";
    @JsonProperty(value="trigger")
    private PipelineTrigger trigger = null;
    public static final String JSON_PROPERTY_VCS = "vcs";
    @JsonProperty(value="vcs")
    private PipelineVcs vcs = null;

    public Pipeline id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique ID of the pipeline.")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Pipeline errors(List<PipelineErrors> errors) {
        this.errors = errors;
        return this;
    }

    public Pipeline addErrorsItem(PipelineErrors errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A sequence of errors that have occurred within the pipeline.")
    public List<PipelineErrors> getErrors() {
        return this.errors;
    }

    public void setErrors(List<PipelineErrors> errors) {
        this.errors = errors;
    }

    public Pipeline projectSlug(String projectSlug) {
        this.projectSlug = projectSlug;
        return this;
    }

    @ApiModelProperty(example="gh/CircleCI-Public/api-preview-docs", required=true, value="The project-slug for the pipeline.")
    public String getProjectSlug() {
        return this.projectSlug;
    }

    public void setProjectSlug(String projectSlug) {
        this.projectSlug = projectSlug;
    }

    public Pipeline updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time the pipeline was last updated.")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Pipeline number(Long number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of the pipeline.")
    public Long getNumber() {
        return this.number;
    }

    public void setNumber(Long number) {
        this.number = number;
    }

    public Pipeline state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(required=true, value="The current state of the pipeline.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public Pipeline createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time the pipeline was created.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Pipeline trigger(PipelineTrigger trigger) {
        this.trigger = trigger;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PipelineTrigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(PipelineTrigger trigger) {
        this.trigger = trigger;
    }

    public Pipeline vcs(PipelineVcs vcs) {
        this.vcs = vcs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PipelineVcs getVcs() {
        return this.vcs;
    }

    public void setVcs(PipelineVcs vcs) {
        this.vcs = vcs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pipeline pipeline = (Pipeline)o;
        return Objects.equals(this.id, pipeline.id) && Objects.equals(this.errors, pipeline.errors) && Objects.equals(this.projectSlug, pipeline.projectSlug) && Objects.equals(this.updatedAt, pipeline.updatedAt) && Objects.equals(this.number, pipeline.number) && Objects.equals((Object)this.state, (Object)pipeline.state) && Objects.equals(this.createdAt, pipeline.createdAt) && Objects.equals(this.trigger, pipeline.trigger) && Objects.equals(this.vcs, pipeline.vcs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.errors, this.projectSlug, this.updatedAt, this.number, this.state, this.createdAt, this.trigger, this.vcs});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pipeline {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    projectSlug: ").append(this.toIndentedString(this.projectSlug)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    trigger: ").append(this.toIndentedString(this.trigger)).append("\n");
        sb.append("    vcs: ").append(this.toIndentedString(this.vcs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        CREATED("created"),
        ERRORED("errored"),
        PENDING("pending");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

