/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Information about the VCS that hosts the project source code.")
public class ProjectVcsInfo {
    public static final String JSON_PROPERTY_VCS_URL = "vcs_url";
    @JsonProperty(value="vcs_url")
    private String vcsUrl;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    @JsonProperty(value="provider")
    private ProviderEnum provider;
    public static final String JSON_PROPERTY_DEFAULT_BRANCH = "default_branch";
    @JsonProperty(value="default_branch")
    private String defaultBranch;

    public ProjectVcsInfo vcsUrl(String vcsUrl) {
        this.vcsUrl = vcsUrl;
        return this;
    }

    @ApiModelProperty(example="https://github.com/CircleCI-Public/api-preview-docs", required=true, value="URL to the repository hosting the project's code")
    public String getVcsUrl() {
        return this.vcsUrl;
    }

    public void setVcsUrl(String vcsUrl) {
        this.vcsUrl = vcsUrl;
    }

    public ProjectVcsInfo provider(ProviderEnum provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(required=true, value="The VCS provider")
    public ProviderEnum getProvider() {
        return this.provider;
    }

    public void setProvider(ProviderEnum provider) {
        this.provider = provider;
    }

    public ProjectVcsInfo defaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
        return this;
    }

    @ApiModelProperty(example="master", required=true, value="")
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectVcsInfo projectVcsInfo = (ProjectVcsInfo)o;
        return Objects.equals(this.vcsUrl, projectVcsInfo.vcsUrl) && Objects.equals((Object)this.provider, (Object)projectVcsInfo.provider) && Objects.equals(this.defaultBranch, projectVcsInfo.defaultBranch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vcsUrl, this.provider, this.defaultBranch});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectVcsInfo {\n");
        sb.append("    vcsUrl: ").append(this.toIndentedString(this.vcsUrl)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("    defaultBranch: ").append(this.toIndentedString(this.defaultBranch)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProviderEnum {
        BITBUCKET("Bitbucket"),
        GITHUB("GitHub");

        private String value;

        private ProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProviderEnum fromValue(String value) {
            for (ProviderEnum b : ProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

