/*
 * CircleCI API
 * This describes the resources that make up the CircleCI API v2. API v2 is currently in Preview. Additional documentation for this API can be found in the [API Preview Docs](https://github.com/CircleCI-Public/api-preview-docs/tree/master/docs). Breaking changes to the API will be announced in the [Breaking Changes log](https://github.com/CircleCI-Public/api-preview-docs/blob/master/docs/breaking.md).
 *
 * The version of the OpenAPI document: v2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.circleci.client.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Metrics relating to the duration of runs for a workflow.
 */
@ApiModel(description = "Metrics relating to the duration of runs for a workflow.")

public class InlineResponse200MetricsDurationMetrics {
  public static final String JSON_PROPERTY_MIN = "min";
  @JsonProperty(JSON_PROPERTY_MIN)
  private Long min;

  public static final String JSON_PROPERTY_MEAN = "mean";
  @JsonProperty(JSON_PROPERTY_MEAN)
  private Long mean;

  public static final String JSON_PROPERTY_MEDIAN = "median";
  @JsonProperty(JSON_PROPERTY_MEDIAN)
  private Long median;

  public static final String JSON_PROPERTY_P95 = "p95";
  @JsonProperty(JSON_PROPERTY_P95)
  private Long p95;

  public static final String JSON_PROPERTY_MAX = "max";
  @JsonProperty(JSON_PROPERTY_MAX)
  private Long max;

  public static final String JSON_PROPERTY_STANDARD_DEVIATION = "standard_deviation";
  @JsonProperty(JSON_PROPERTY_STANDARD_DEVIATION)
  private Float standardDeviation;

  public InlineResponse200MetricsDurationMetrics min(Long min) {
    this.min = min;
    return this;
  }

   /**
   * The minimum duration, in seconds, among a group of runs.
   * minimum: 0
   * @return min
  **/
  @ApiModelProperty(required = true, value = "The minimum duration, in seconds, among a group of runs.")
  public Long getMin() {
    return min;
  }

  public void setMin(Long min) {
    this.min = min;
  }

  public InlineResponse200MetricsDurationMetrics mean(Long mean) {
    this.mean = mean;
    return this;
  }

   /**
   * The mean duration, in seconds, among a group of runs.
   * minimum: 0
   * @return mean
  **/
  @ApiModelProperty(required = true, value = "The mean duration, in seconds, among a group of runs.")
  public Long getMean() {
    return mean;
  }

  public void setMean(Long mean) {
    this.mean = mean;
  }

  public InlineResponse200MetricsDurationMetrics median(Long median) {
    this.median = median;
    return this;
  }

   /**
   * The median duration, in seconds, among a group of runs.
   * minimum: 0
   * @return median
  **/
  @ApiModelProperty(required = true, value = "The median duration, in seconds, among a group of runs.")
  public Long getMedian() {
    return median;
  }

  public void setMedian(Long median) {
    this.median = median;
  }

  public InlineResponse200MetricsDurationMetrics p95(Long p95) {
    this.p95 = p95;
    return this;
  }

   /**
   * The 95th percentile duration, in seconds, among a group of runs.
   * minimum: 0
   * @return p95
  **/
  @ApiModelProperty(required = true, value = "The 95th percentile duration, in seconds, among a group of runs.")
  public Long getP95() {
    return p95;
  }

  public void setP95(Long p95) {
    this.p95 = p95;
  }

  public InlineResponse200MetricsDurationMetrics max(Long max) {
    this.max = max;
    return this;
  }

   /**
   * The max duration, in seconds, among a group of runs.
   * minimum: 0
   * @return max
  **/
  @ApiModelProperty(required = true, value = "The max duration, in seconds, among a group of runs.")
  public Long getMax() {
    return max;
  }

  public void setMax(Long max) {
    this.max = max;
  }

  public InlineResponse200MetricsDurationMetrics standardDeviation(Float standardDeviation) {
    this.standardDeviation = standardDeviation;
    return this;
  }

   /**
   * The standard deviation, in seconds, among a group of runs.
   * @return standardDeviation
  **/
  @ApiModelProperty(required = true, value = "The standard deviation, in seconds, among a group of runs.")
  public Float getStandardDeviation() {
    return standardDeviation;
  }

  public void setStandardDeviation(Float standardDeviation) {
    this.standardDeviation = standardDeviation;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InlineResponse200MetricsDurationMetrics inlineResponse200MetricsDurationMetrics = (InlineResponse200MetricsDurationMetrics) o;
    return Objects.equals(this.min, inlineResponse200MetricsDurationMetrics.min) &&
        Objects.equals(this.mean, inlineResponse200MetricsDurationMetrics.mean) &&
        Objects.equals(this.median, inlineResponse200MetricsDurationMetrics.median) &&
        Objects.equals(this.p95, inlineResponse200MetricsDurationMetrics.p95) &&
        Objects.equals(this.max, inlineResponse200MetricsDurationMetrics.max) &&
        Objects.equals(this.standardDeviation, inlineResponse200MetricsDurationMetrics.standardDeviation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(min, mean, median, p95, max, standardDeviation);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InlineResponse200MetricsDurationMetrics {\n");
    sb.append("    min: ").append(toIndentedString(min)).append("\n");
    sb.append("    mean: ").append(toIndentedString(mean)).append("\n");
    sb.append("    median: ").append(toIndentedString(median)).append("\n");
    sb.append("    p95: ").append(toIndentedString(p95)).append("\n");
    sb.append("    max: ").append(toIndentedString(max)).append("\n");
    sb.append("    standardDeviation: ").append(toIndentedString(standardDeviation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

