/*
 * CircleCI API
 * This describes the resources that make up the CircleCI API v2. API v2 is currently in Preview. Additional documentation for this API can be found in the [API Preview Docs](https://github.com/CircleCI-Public/api-preview-docs/tree/master/docs). Breaking changes to the API will be announced in the [Breaking Changes log](https://github.com/CircleCI-Public/api-preview-docs/blob/master/docs/breaking.md).
 *
 * The version of the OpenAPI document: v2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.circleci.client.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.circleci.client.v2.model.ProjectVcsInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * NOTE: The definition of Project is subject to change.
 */
@ApiModel(description = "NOTE: The definition of Project is subject to change.")

public class Project {
  public static final String JSON_PROPERTY_SLUG = "slug";
  @JsonProperty(JSON_PROPERTY_SLUG)
  private String slug;

  public static final String JSON_PROPERTY_NAME = "name";
  @JsonProperty(JSON_PROPERTY_NAME)
  private String name;

  public static final String JSON_PROPERTY_ORGANIZATION_NAME = "organization_name";
  @JsonProperty(JSON_PROPERTY_ORGANIZATION_NAME)
  private String organizationName;

  public static final String JSON_PROPERTY_VCS_INFO = "vcs_info";
  @JsonProperty(JSON_PROPERTY_VCS_INFO)
  private ProjectVcsInfo vcsInfo = null;

  public Project slug(String slug) {
    this.slug = slug;
    return this;
  }

   /**
   * Project slug in the form &#x60;vcs-slug/org-name/repo-name&#x60;. The &#x60;/&#x60; characters may be URL-escaped.
   * @return slug
  **/
  @ApiModelProperty(example = "gh/CircleCI-Public/api-preview-docs", required = true, value = "Project slug in the form `vcs-slug/org-name/repo-name`. The `/` characters may be URL-escaped.")
  public String getSlug() {
    return slug;
  }

  public void setSlug(String slug) {
    this.slug = slug;
  }

  public Project name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the project
   * @return name
  **/
  @ApiModelProperty(example = "api-preview-docs", required = true, value = "The name of the project")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Project organizationName(String organizationName) {
    this.organizationName = organizationName;
    return this;
  }

   /**
   * The name of the organization the project belongs to
   * @return organizationName
  **/
  @ApiModelProperty(example = "CircleCI-Public", required = true, value = "The name of the organization the project belongs to")
  public String getOrganizationName() {
    return organizationName;
  }

  public void setOrganizationName(String organizationName) {
    this.organizationName = organizationName;
  }

  public Project vcsInfo(ProjectVcsInfo vcsInfo) {
    this.vcsInfo = vcsInfo;
    return this;
  }

   /**
   * Get vcsInfo
   * @return vcsInfo
  **/
  @ApiModelProperty(required = true, value = "")
  public ProjectVcsInfo getVcsInfo() {
    return vcsInfo;
  }

  public void setVcsInfo(ProjectVcsInfo vcsInfo) {
    this.vcsInfo = vcsInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Project project = (Project) o;
    return Objects.equals(this.slug, project.slug) &&
        Objects.equals(this.name, project.name) &&
        Objects.equals(this.organizationName, project.organizationName) &&
        Objects.equals(this.vcsInfo, project.vcsInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(slug, name, organizationName, vcsInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Project {\n");
    sb.append("    slug: ").append(toIndentedString(slug)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    organizationName: ").append(toIndentedString(organizationName)).append("\n");
    sb.append("    vcsInfo: ").append(toIndentedString(vcsInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

