/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@ApiModel(description="The information you can supply when rerunning a workflow.")
public class RerunWorkflowParameters {
    public static final String JSON_PROPERTY_JOBS = "jobs";
    @JsonProperty(value="jobs")
    private List<UUID> jobs = new ArrayList<UUID>();
    public static final String JSON_PROPERTY_FROM_FAILED = "from_failed";
    @JsonProperty(value="from_failed")
    private Boolean fromFailed;

    public RerunWorkflowParameters jobs(List<UUID> jobs) {
        this.jobs = jobs;
        return this;
    }

    public RerunWorkflowParameters addJobsItem(UUID jobsItem) {
        if (this.jobs == null) {
            this.jobs = new ArrayList<UUID>();
        }
        this.jobs.add(jobsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"c65b68ef-e73b-4bf2-be9a-7a322a9df150\",\"5e957edd-5e8c-4985-9178-5d0d69561822\"]", value="A list of job IDs to rerun.")
    public List<UUID> getJobs() {
        return this.jobs;
    }

    public void setJobs(List<UUID> jobs) {
        this.jobs = jobs;
    }

    public RerunWorkflowParameters fromFailed(Boolean fromFailed) {
        this.fromFailed = fromFailed;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether to rerun the workflow from the failed job. Mutually exclusive with the jobs parameter.")
    public Boolean getFromFailed() {
        return this.fromFailed;
    }

    public void setFromFailed(Boolean fromFailed) {
        this.fromFailed = fromFailed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RerunWorkflowParameters rerunWorkflowParameters = (RerunWorkflowParameters)o;
        return Objects.equals(this.jobs, rerunWorkflowParameters.jobs) && Objects.equals(this.fromFailed, rerunWorkflowParameters.fromFailed);
    }

    public int hashCode() {
        return Objects.hash(this.jobs, this.fromFailed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RerunWorkflowParameters {\n");
        sb.append("    jobs: ").append(this.toIndentedString(this.jobs)).append("\n");
        sb.append("    fromFailed: ").append(this.toIndentedString(this.fromFailed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

