/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.api;

import com.circleci.client.v2.ApiClient;
import com.circleci.client.v2.ApiException;
import com.circleci.client.v2.ApiResponse;
import com.circleci.client.v2.Configuration;
import com.circleci.client.v2.Pair;
import com.circleci.client.v2.model.PipelineWithWorkflows;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.ws.rs.core.GenericType;

public class PipelinesApi {
    private ApiClient apiClient;

    public PipelinesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PipelinesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public PipelineWithWorkflows getPipelineById(UUID pipelineId) throws ApiException {
        return this.getPipelineByIdWithHttpInfo(pipelineId).getData();
    }

    public ApiResponse<PipelineWithWorkflows> getPipelineByIdWithHttpInfo(UUID pipelineId) throws ApiException {
        Object localVarPostBody = new Object();
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling getPipelineById");
        }
        String localVarPath = "/pipeline/{pipeline-id}".replaceAll("\\{pipeline-id\\}", this.apiClient.escapeString(pipelineId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<PipelineWithWorkflows> localVarReturnType = new GenericType<PipelineWithWorkflows>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

