/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.api;

import com.circleci.client.v2.ApiClient;
import com.circleci.client.v2.ApiException;
import com.circleci.client.v2.ApiResponse;
import com.circleci.client.v2.Configuration;
import com.circleci.client.v2.Pair;
import com.circleci.client.v2.model.Workflow;
import com.circleci.client.v2.model.WorkflowJobListResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.ws.rs.core.GenericType;

public class WorkflowApi {
    private ApiClient apiClient;

    public WorkflowApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Workflow getWorkflowById(UUID id) throws ApiException {
        return this.getWorkflowByIdWithHttpInfo(id).getData();
    }

    public ApiResponse<Workflow> getWorkflowByIdWithHttpInfo(UUID id) throws ApiException {
        Object localVarPostBody = new Object();
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getWorkflowById");
        }
        String localVarPath = "/workflow/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<Workflow> localVarReturnType = new GenericType<Workflow>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public WorkflowJobListResponse listWorkflowJobs(UUID id) throws ApiException {
        return this.listWorkflowJobsWithHttpInfo(id).getData();
    }

    public ApiResponse<WorkflowJobListResponse> listWorkflowJobsWithHttpInfo(UUID id) throws ApiException {
        Object localVarPostBody = new Object();
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling listWorkflowJobs");
        }
        String localVarPath = "/workflow/{id}/jobs".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<WorkflowJobListResponse> localVarReturnType = new GenericType<WorkflowJobListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

