/*
 * CircleCI API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.circleci.client.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Information about the VCS that hosts the project source code.
 */
@ApiModel(description = "Information about the VCS that hosts the project source code.")

public class ProjectVcsInfo {
  public static final String JSON_PROPERTY_VCS_URL = "vcs_url";
  @JsonProperty(JSON_PROPERTY_VCS_URL)
  private String vcsUrl;

  /**
   * The VCS provider
   */
  public enum ProviderEnum {
    BITBUCKET("Bitbucket"),
    
    GITHUB("GitHub");

    private String value;

    ProviderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ProviderEnum fromValue(String value) {
      for (ProviderEnum b : ProviderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PROVIDER = "provider";
  @JsonProperty(JSON_PROPERTY_PROVIDER)
  private ProviderEnum provider;

  public static final String JSON_PROPERTY_DEFAULT_BRANCH = "default_branch";
  @JsonProperty(JSON_PROPERTY_DEFAULT_BRANCH)
  private String defaultBranch;

  public ProjectVcsInfo vcsUrl(String vcsUrl) {
    this.vcsUrl = vcsUrl;
    return this;
  }

   /**
   * URL to the repository hosting the project&#39;s code
   * @return vcsUrl
  **/
  @ApiModelProperty(example = "https://github.com/CircleCI-Public/api-preview-docs", required = true, value = "URL to the repository hosting the project's code")
  public String getVcsUrl() {
    return vcsUrl;
  }

  public void setVcsUrl(String vcsUrl) {
    this.vcsUrl = vcsUrl;
  }

  public ProjectVcsInfo provider(ProviderEnum provider) {
    this.provider = provider;
    return this;
  }

   /**
   * The VCS provider
   * @return provider
  **/
  @ApiModelProperty(required = true, value = "The VCS provider")
  public ProviderEnum getProvider() {
    return provider;
  }

  public void setProvider(ProviderEnum provider) {
    this.provider = provider;
  }

  public ProjectVcsInfo defaultBranch(String defaultBranch) {
    this.defaultBranch = defaultBranch;
    return this;
  }

   /**
   * Get defaultBranch
   * @return defaultBranch
  **/
  @ApiModelProperty(example = "master", required = true, value = "")
  public String getDefaultBranch() {
    return defaultBranch;
  }

  public void setDefaultBranch(String defaultBranch) {
    this.defaultBranch = defaultBranch;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProjectVcsInfo projectVcsInfo = (ProjectVcsInfo) o;
    return Objects.equals(this.vcsUrl, projectVcsInfo.vcsUrl) &&
        Objects.equals(this.provider, projectVcsInfo.provider) &&
        Objects.equals(this.defaultBranch, projectVcsInfo.defaultBranch);
  }

  @Override
  public int hashCode() {
    return Objects.hash(vcsUrl, provider, defaultBranch);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProjectVcsInfo {\n");
    sb.append("    vcsUrl: ").append(toIndentedString(vcsUrl)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    defaultBranch: ").append(toIndentedString(defaultBranch)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

