/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;

@ApiModel(description="NOTE: The definition of pipeline is subject to change.")
public class PipelineLight {
    public static final String JSON_PROPERTY_ID = "id";
    @JsonProperty(value="id")
    private UUID id;
    public static final String JSON_PROPERTY_STATE = "state";
    @JsonProperty(value="state")
    private StateEnum state;
    public static final String JSON_PROPERTY_NUMBER = "number";
    @JsonProperty(value="number")
    private Long number;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    @JsonProperty(value="created_at")
    private OffsetDateTime createdAt;

    public PipelineLight id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique ID of the pipeline.")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public PipelineLight state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(required=true, value="The current state of the pipeline.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public PipelineLight number(Long number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of the pipeline.")
    public Long getNumber() {
        return this.number;
    }

    public void setNumber(Long number) {
        this.number = number;
    }

    public PipelineLight createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time the pipeline was created.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineLight pipelineLight = (PipelineLight)o;
        return Objects.equals(this.id, pipelineLight.id) && Objects.equals((Object)this.state, (Object)pipelineLight.state) && Objects.equals(this.number, pipelineLight.number) && Objects.equals(this.createdAt, pipelineLight.createdAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.number, this.createdAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PipelineLight {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        CREATED("created"),
        RUNNING("running"),
        FAILED("failed"),
        ERRORED("errored"),
        SUCCESSFUL("successful"),
        ON_HOLD("on_hold"),
        BLOCKED("blocked"),
        PENDING("pending"),
        CANCELED("canceled");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

