/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.model;

import com.circleci.client.v2.model.JobDetailsContexts;
import com.circleci.client.v2.model.JobDetailsExecutor;
import com.circleci.client.v2.model.JobDetailsLatestWorkflow;
import com.circleci.client.v2.model.JobDetailsMessages;
import com.circleci.client.v2.model.JobDetailsOrganization;
import com.circleci.client.v2.model.JobDetailsParallelRuns;
import com.circleci.client.v2.model.JobDetailsPipeline;
import com.circleci.client.v2.model.JobDetailsProject;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Job Details")
public class JobDetails {
    public static final String JSON_PROPERTY_WEB_URL = "web_url";
    @JsonProperty(value="web_url")
    private String webUrl;
    public static final String JSON_PROPERTY_PROJECT = "project";
    @JsonProperty(value="project")
    private JobDetailsProject project = null;
    public static final String JSON_PROPERTY_PARALLEL_RUNS = "parallel_runs";
    @JsonProperty(value="parallel_runs")
    private List<JobDetailsParallelRuns> parallelRuns = new ArrayList<JobDetailsParallelRuns>();
    public static final String JSON_PROPERTY_STARTED_AT = "started_at";
    @JsonProperty(value="started_at")
    private OffsetDateTime startedAt;
    public static final String JSON_PROPERTY_LATEST_WORKFLOW = "latest_workflow";
    @JsonProperty(value="latest_workflow")
    private JobDetailsLatestWorkflow latestWorkflow = null;
    public static final String JSON_PROPERTY_NAME = "name";
    @JsonProperty(value="name")
    private String name;
    public static final String JSON_PROPERTY_EXECUTOR = "executor";
    @JsonProperty(value="executor")
    private JobDetailsExecutor executor = null;
    public static final String JSON_PROPERTY_PARALLELISM = "parallelism";
    @JsonProperty(value="parallelism")
    private Long parallelism;
    public static final String JSON_PROPERTY_STATUS = "status";
    @JsonProperty(value="status")
    private Object status = null;
    public static final String JSON_PROPERTY_NUMBER = "number";
    @JsonProperty(value="number")
    private Long number;
    public static final String JSON_PROPERTY_PIPELINE = "pipeline";
    @JsonProperty(value="pipeline")
    private JobDetailsPipeline pipeline = null;
    public static final String JSON_PROPERTY_DURATION = "duration";
    @JsonProperty(value="duration")
    private Long duration;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    @JsonProperty(value="created_at")
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_MESSAGES = "messages";
    @JsonProperty(value="messages")
    private List<JobDetailsMessages> messages = new ArrayList<JobDetailsMessages>();
    public static final String JSON_PROPERTY_CONTEXTS = "contexts";
    @JsonProperty(value="contexts")
    private List<JobDetailsContexts> contexts = new ArrayList<JobDetailsContexts>();
    public static final String JSON_PROPERTY_ORGANIZATION = "organization";
    @JsonProperty(value="organization")
    private JobDetailsOrganization organization = null;
    public static final String JSON_PROPERTY_QUEUED_AT = "queued_at";
    @JsonProperty(value="queued_at")
    private OffsetDateTime queuedAt;
    public static final String JSON_PROPERTY_STOPPED_AT = "stopped_at";
    @JsonProperty(value="stopped_at")
    private OffsetDateTime stoppedAt;

    public JobDetails webUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="URL of the job in CircleCI Web UI.")
    public String getWebUrl() {
        return this.webUrl;
    }

    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    public JobDetails project(JobDetailsProject project) {
        this.project = project;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public JobDetailsProject getProject() {
        return this.project;
    }

    public void setProject(JobDetailsProject project) {
        this.project = project;
    }

    public JobDetails parallelRuns(List<JobDetailsParallelRuns> parallelRuns) {
        this.parallelRuns = parallelRuns;
        return this;
    }

    public JobDetails addParallelRunsItem(JobDetailsParallelRuns parallelRunsItem) {
        this.parallelRuns.add(parallelRunsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Info about parallels runs and their status.")
    public List<JobDetailsParallelRuns> getParallelRuns() {
        return this.parallelRuns;
    }

    public void setParallelRuns(List<JobDetailsParallelRuns> parallelRuns) {
        this.parallelRuns = parallelRuns;
    }

    public JobDetails startedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time the job started.")
    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
    }

    public JobDetails latestWorkflow(JobDetailsLatestWorkflow latestWorkflow) {
        this.latestWorkflow = latestWorkflow;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public JobDetailsLatestWorkflow getLatestWorkflow() {
        return this.latestWorkflow;
    }

    public void setLatestWorkflow(JobDetailsLatestWorkflow latestWorkflow) {
        this.latestWorkflow = latestWorkflow;
    }

    public JobDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the job.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JobDetails executor(JobDetailsExecutor executor) {
        this.executor = executor;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public JobDetailsExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(JobDetailsExecutor executor) {
        this.executor = executor;
    }

    public JobDetails parallelism(Long parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    @ApiModelProperty(required=true, value="A number of parallel runs the job has.")
    public Long getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(Long parallelism) {
        this.parallelism = parallelism;
    }

    public JobDetails status(Object status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The current status of the job.")
    public Object getStatus() {
        return this.status;
    }

    public void setStatus(Object status) {
        this.status = status;
    }

    public JobDetails number(Long number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of the job.")
    public Long getNumber() {
        return this.number;
    }

    public void setNumber(Long number) {
        this.number = number;
    }

    public JobDetails pipeline(JobDetailsPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public JobDetailsPipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(JobDetailsPipeline pipeline) {
        this.pipeline = pipeline;
    }

    public JobDetails duration(Long duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(required=true, value="Duration of a job in milliseconds.")
    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public JobDetails createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The time when the job was created.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public JobDetails messages(List<JobDetailsMessages> messages) {
        this.messages = messages;
        return this;
    }

    public JobDetails addMessagesItem(JobDetailsMessages messagesItem) {
        this.messages.add(messagesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Messages from CircleCI execution platform.")
    public List<JobDetailsMessages> getMessages() {
        return this.messages;
    }

    public void setMessages(List<JobDetailsMessages> messages) {
        this.messages = messages;
    }

    public JobDetails contexts(List<JobDetailsContexts> contexts) {
        this.contexts = contexts;
        return this;
    }

    public JobDetails addContextsItem(JobDetailsContexts contextsItem) {
        this.contexts.add(contextsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of contexts used by the job.")
    public List<JobDetailsContexts> getContexts() {
        return this.contexts;
    }

    public void setContexts(List<JobDetailsContexts> contexts) {
        this.contexts = contexts;
    }

    public JobDetails organization(JobDetailsOrganization organization) {
        this.organization = organization;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public JobDetailsOrganization getOrganization() {
        return this.organization;
    }

    public void setOrganization(JobDetailsOrganization organization) {
        this.organization = organization;
    }

    public JobDetails queuedAt(OffsetDateTime queuedAt) {
        this.queuedAt = queuedAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The time when the job was placed in a queue.")
    public OffsetDateTime getQueuedAt() {
        return this.queuedAt;
    }

    public void setQueuedAt(OffsetDateTime queuedAt) {
        this.queuedAt = queuedAt;
    }

    public JobDetails stoppedAt(OffsetDateTime stoppedAt) {
        this.stoppedAt = stoppedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time when the job stopped.")
    public OffsetDateTime getStoppedAt() {
        return this.stoppedAt;
    }

    public void setStoppedAt(OffsetDateTime stoppedAt) {
        this.stoppedAt = stoppedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDetails jobDetails = (JobDetails)o;
        return Objects.equals(this.webUrl, jobDetails.webUrl) && Objects.equals(this.project, jobDetails.project) && Objects.equals(this.parallelRuns, jobDetails.parallelRuns) && Objects.equals(this.startedAt, jobDetails.startedAt) && Objects.equals(this.latestWorkflow, jobDetails.latestWorkflow) && Objects.equals(this.name, jobDetails.name) && Objects.equals(this.executor, jobDetails.executor) && Objects.equals(this.parallelism, jobDetails.parallelism) && Objects.equals(this.status, jobDetails.status) && Objects.equals(this.number, jobDetails.number) && Objects.equals(this.pipeline, jobDetails.pipeline) && Objects.equals(this.duration, jobDetails.duration) && Objects.equals(this.createdAt, jobDetails.createdAt) && Objects.equals(this.messages, jobDetails.messages) && Objects.equals(this.contexts, jobDetails.contexts) && Objects.equals(this.organization, jobDetails.organization) && Objects.equals(this.queuedAt, jobDetails.queuedAt) && Objects.equals(this.stoppedAt, jobDetails.stoppedAt);
    }

    public int hashCode() {
        return Objects.hash(this.webUrl, this.project, this.parallelRuns, this.startedAt, this.latestWorkflow, this.name, this.executor, this.parallelism, this.status, this.number, this.pipeline, this.duration, this.createdAt, this.messages, this.contexts, this.organization, this.queuedAt, this.stoppedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobDetails {\n");
        sb.append("    webUrl: ").append(this.toIndentedString(this.webUrl)).append("\n");
        sb.append("    project: ").append(this.toIndentedString(this.project)).append("\n");
        sb.append("    parallelRuns: ").append(this.toIndentedString(this.parallelRuns)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    latestWorkflow: ").append(this.toIndentedString(this.latestWorkflow)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    executor: ").append(this.toIndentedString(this.executor)).append("\n");
        sb.append("    parallelism: ").append(this.toIndentedString(this.parallelism)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    pipeline: ").append(this.toIndentedString(this.pipeline)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    messages: ").append(this.toIndentedString(this.messages)).append("\n");
        sb.append("    contexts: ").append(this.toIndentedString(this.contexts)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    queuedAt: ").append(this.toIndentedString(this.queuedAt)).append("\n");
        sb.append("    stoppedAt: ").append(this.toIndentedString(this.stoppedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

