/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An artifact")
public class Artifact {
    public static final String JSON_PROPERTY_PATH = "path";
    @JsonProperty(value="path")
    private String path;
    public static final String JSON_PROPERTY_NODE_INDEX = "node_index";
    @JsonProperty(value="node_index")
    private Long nodeIndex;
    public static final String JSON_PROPERTY_URL = "url";
    @JsonProperty(value="url")
    private String url;

    public Artifact path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="The artifact path.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Artifact nodeIndex(Long nodeIndex) {
        this.nodeIndex = nodeIndex;
        return this;
    }

    @ApiModelProperty(required=true, value="The index of the node that stored the artifact.")
    public Long getNodeIndex() {
        return this.nodeIndex;
    }

    public void setNodeIndex(Long nodeIndex) {
        this.nodeIndex = nodeIndex;
    }

    public Artifact url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(required=true, value="The URL to download the artifact contents.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Artifact artifact = (Artifact)o;
        return Objects.equals(this.path, artifact.path) && Objects.equals(this.nodeIndex, artifact.nodeIndex) && Objects.equals(this.url, artifact.url);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.nodeIndex, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Artifact {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    nodeIndex: ").append(this.toIndentedString(this.nodeIndex)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

