/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@ApiModel(description="Job")
public class Job {
    public static final String JSON_PROPERTY_DEPENDENCIES = "dependencies";
    @JsonProperty(value="dependencies")
    private List<UUID> dependencies = new ArrayList<UUID>();
    public static final String JSON_PROPERTY_JOB_NUMBER = "job_number";
    @JsonProperty(value="job_number")
    private Long jobNumber;
    public static final String JSON_PROPERTY_ID = "id";
    @JsonProperty(value="id")
    private UUID id;
    public static final String JSON_PROPERTY_STARTED_AT = "started_at";
    @JsonProperty(value="started_at")
    private OffsetDateTime startedAt;
    public static final String JSON_PROPERTY_NAME = "name";
    @JsonProperty(value="name")
    private String name;
    public static final String JSON_PROPERTY_PROJECT_SLUG = "project_slug";
    @JsonProperty(value="project_slug")
    private String projectSlug;
    public static final String JSON_PROPERTY_STATUS = "status";
    @JsonProperty(value="status")
    private Object status = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    @JsonProperty(value="type")
    private TypeEnum type;
    public static final String JSON_PROPERTY_STOPPED_AT = "stopped_at";
    @JsonProperty(value="stopped_at")
    private OffsetDateTime stoppedAt;

    public Job dependencies(List<UUID> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public Job addDependenciesItem(UUID dependenciesItem) {
        this.dependencies.add(dependenciesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A sequence of the unique job IDs for the jobs that this job depends upon in the workflow.")
    public List<UUID> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<UUID> dependencies) {
        this.dependencies = dependencies;
    }

    public Job jobNumber(Long jobNumber) {
        this.jobNumber = jobNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of the job.")
    public Long getJobNumber() {
        return this.jobNumber;
    }

    public void setJobNumber(Long jobNumber) {
        this.jobNumber = jobNumber;
    }

    public Job id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique ID of the job.")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Job startedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time the job started.")
    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
    }

    public Job name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the job.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Job projectSlug(String projectSlug) {
        this.projectSlug = projectSlug;
        return this;
    }

    @ApiModelProperty(example="gh/CircleCI-Public/api-preview-docs", required=true, value="The project-slug for the job.")
    public String getProjectSlug() {
        return this.projectSlug;
    }

    public void setProjectSlug(String projectSlug) {
        this.projectSlug = projectSlug;
    }

    public Job status(Object status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The current status of the job.")
    public Object getStatus() {
        return this.status;
    }

    public void setStatus(Object status) {
        this.status = status;
    }

    public Job type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of job.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Job stoppedAt(OffsetDateTime stoppedAt) {
        this.stoppedAt = stoppedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time when the job stopped.")
    public OffsetDateTime getStoppedAt() {
        return this.stoppedAt;
    }

    public void setStoppedAt(OffsetDateTime stoppedAt) {
        this.stoppedAt = stoppedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        return Objects.equals(this.dependencies, job.dependencies) && Objects.equals(this.jobNumber, job.jobNumber) && Objects.equals(this.id, job.id) && Objects.equals(this.startedAt, job.startedAt) && Objects.equals(this.name, job.name) && Objects.equals(this.projectSlug, job.projectSlug) && Objects.equals(this.status, job.status) && Objects.equals((Object)this.type, (Object)job.type) && Objects.equals(this.stoppedAt, job.stoppedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dependencies, this.jobNumber, this.id, this.startedAt, this.name, this.projectSlug, this.status, this.type, this.stoppedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Job {\n");
        sb.append("    dependencies: ").append(this.toIndentedString(this.dependencies)).append("\n");
        sb.append("    jobNumber: ").append(this.toIndentedString(this.jobNumber)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    projectSlug: ").append(this.toIndentedString(this.projectSlug)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    stoppedAt: ").append(this.toIndentedString(this.stoppedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        BUILD("build"),
        APPROVAL("approval");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

