/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.component;

import com.cloudimpl.outstack.core.CloudUtil;
import com.cloudimpl.outstack.core.ComponentProvider;
import com.cloudimpl.outstack.core.ComponentProviderManager;
import com.cloudimpl.outstack.core.Injector;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
@ConfigurationProperties(value="outstack")
public class SpringApplicationConfigManager
implements ComponentProviderManager {
    private String domainOwner;
    private String domainContext;
    private String apiContext;
    private Cluster cluster = new Cluster();
    private Map<String, List<Provider>> providers;
    private Injector injector;

    public String getApiContext() {
        Objects.requireNonNull(this.apiContext);
        return this.apiContext;
    }

    public void setApiContext(String apiContext) {
        this.apiContext = apiContext;
    }

    protected void setInjector(Injector injector) {
        this.injector = injector;
    }

    public void setProviders(Map<String, List<Provider>> providers) {
        this.providers = providers;
    }

    public String getDomainOwner() {
        Objects.requireNonNull(this.domainOwner);
        return this.domainOwner;
    }

    public void setDomainOwner(String domainOwner) {
        this.domainOwner = domainOwner;
    }

    public String getDomainContext() {
        Objects.requireNonNull(this.domainContext);
        return this.domainContext;
    }

    public void setDomainContext(String domainContext) {
        this.domainContext = domainContext;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public Collection<Provider> getProviders() {
        return this.providers.entrySet().stream().peek(e -> ((List)e.getValue()).forEach(p -> p.setBase((String)e.getKey()))).map(e -> (List)e.getValue()).flatMap(l -> l.stream()).peek(p -> p.setInjector(this.injector)).collect(Collectors.toList());
    }

    public Optional<ComponentProvider> getProvider(String name) {
        return Optional.ofNullable(this.providers.get(name)).flatMap(l -> l.stream().filter(p -> p.getStatus().isPresent()).filter(p -> p.getStatus().get().equalsIgnoreCase("active")).peek(p -> p.setInjector(this.injector)).findFirst());
    }

    public static final class Cluster {
        private int servicePort = 10000;
        private String seedName = null;
        private int gossipPort = 12000;
        private List<String> seeds = new LinkedList<String>();

        public int getServicePort() {
            return this.servicePort;
        }

        public void setServicePort(int servicePort) {
            this.servicePort = servicePort;
        }

        public String getSeedName() {
            return this.seedName;
        }

        public void setSeedName(String seedName) {
            this.seedName = seedName;
        }

        public int getGossipPort() {
            return this.gossipPort;
        }

        public void setGossipPort(int gossipPort) {
            this.gossipPort = gossipPort;
        }

        public List<String> getSeeds() {
            return this.seeds;
        }

        public void setSeeds(List<String> seeds) {
            this.seeds = seeds;
        }
    }

    public static final class Provider
    implements ComponentProvider {
        private String name;
        private String impl;
        private String base;
        public Map<String, String> configs = new HashMap<String, String>();
        private String status;
        private Injector injector;

        public void setImpl(String impl) {
            this.impl = impl;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getBase() {
            return this.base;
        }

        public void setBase(String base) {
            this.base = base;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Optional<String> getStatus() {
            return Optional.ofNullable(this.status);
        }

        public String getName() {
            return this.name;
        }

        protected void setInjector(Injector injector) {
            this.injector = injector;
        }

        public String getImpl() {
            return this.impl;
        }

        public void setConfigs(Map<String, String> configs) {
            this.configs = configs;
        }

        public String toString() {
            return "Provider{name=" + this.name + ", impl=" + this.impl + "}";
        }

        public <T> T getInstance() {
            return (T)this.injector.with(ComponentProvider.ProviderConfigs.class, (Object)this.getOptions()).inject(CloudUtil.classForName((String)this.getImpl()));
        }

        public ComponentProvider.ProviderConfigs getOptions() {
            return (option, defaultVal) -> Optional.ofNullable(this.configs.getOrDefault(option, defaultVal));
        }
    }
}

