/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.component.swagger;

import com.cloudimpl.outstack.spring.service.RestControllerService;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Configuration
public class SwaggerConfig {
    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2).select().apis(h -> false).paths(s -> false).build();
    }

    @Primary
    @Bean
    public SwaggerResourcesProvider swaggerResourcesProvider() {
        return () -> RestControllerService.domainContextsFlux.values().stream().map(d -> this.createResource(d.getDomainContext())).collect(Collectors.toList());
    }

    private SwaggerResource createResource(String domainContext) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(domainContext);
        swaggerResource.setLocation("/public/" + domainContext + "/v2/api-docs");
        swaggerResource.setSwaggerVersion("2.0");
        return swaggerResource;
    }
}

