/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.repo;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.cloudimpl.outstack.core.ComponentProvider;
import com.cloudimpl.outstack.runtime.EventRepositoryFactory;
import com.cloudimpl.outstack.runtime.EventRepositoy;
import com.cloudimpl.outstack.runtime.ResourceHelper;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.spring.repo.DynamodbEventRepository;

public class DynamodbRepositoryFactory
implements EventRepositoryFactory {
    private final AmazonDynamoDB client;
    private final DynamoDB dynamoDB;
    private final ResourceHelper helper;
    private ComponentProvider.ProviderConfigs providerConfig;

    public DynamodbRepositoryFactory(ResourceHelper helper, ComponentProvider.ProviderConfigs providerConfig) {
        this.helper = helper;
        this.providerConfig = providerConfig;
        this.client = (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration((String)providerConfig.getOption("endpoint").get(), (String)providerConfig.getOption("region").get()))).build();
        this.dynamoDB = new DynamoDB(this.client);
    }

    public <T extends RootEntity> EventRepositoy<T> createOrGetRepository(Class<T> rootType) {
        return mapRepos.computeIfAbsent(rootType, type -> new DynamodbEventRepository(this.client, this.dynamoDB, type, this.helper, this.providerConfig));
    }
}

