/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.repo;

import com.cloudimpl.outstack.core.ComponentProvider;
import com.cloudimpl.outstack.runtime.EventRepositoryFactory;
import com.cloudimpl.outstack.runtime.EventRepositoy;
import com.cloudimpl.outstack.runtime.ResourceHelper;
import com.cloudimpl.outstack.runtime.ResultSet;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.spring.repo.PostgresEventRepository;
import com.cloudimpl.outstack.spring.repo.PostgresException;
import com.cloudimpl.outstack.spring.repo.PostgresSqlNode;
import com.cloudimpl.outstack.spring.repo.SqlResultSet;
import com.cloudimpl.rstack.dsl.restql.RestQLNode;
import com.cloudimpl.rstack.dsl.restql.RestQLParser;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresRepositoryFactory
implements EventRepositoryFactory {
    private static final Logger log = LoggerFactory.getLogger(PostgresRepositoryFactory.class);
    private final ResourceHelper helper;
    private ComponentProvider.ProviderConfigs providerConfig;
    private HikariDataSource ds;
    private HikariConfig config = new HikariConfig();
    private Map<String, String> tenantMap = new ConcurrentHashMap<String, String>();

    public PostgresRepositoryFactory(ResourceHelper helper, ComponentProvider.ProviderConfigs providerConfig) throws ClassNotFoundException {
        Class.forName("org.postgresql.Driver");
        this.helper = helper;
        this.providerConfig = providerConfig;
        this.config.setJdbcUrl((String)providerConfig.getOption("jdbcUrl").get());
        this.config.setUsername((String)providerConfig.getOption("username").get());
        this.config.setPassword((String)providerConfig.getOption("password").get());
        System.out.println((String)providerConfig.getOption("jdbcUrl").get() + "- " + (String)providerConfig.getOption("username").get() + "-" + (String)providerConfig.getOption("password").get());
        this.config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        this.config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        this.config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        this.config.setAutoCommit(false);
        this.ds = new HikariDataSource(this.config);
    }

    private Connection getConnection() {
        try {
            return this.ds.getConnection();
        }
        catch (SQLException ex) {
            throw new PostgresException(ex);
        }
    }

    private void createTenantIfNotExist(String tableName, String tenantId) {
        this.tenantMap.computeIfAbsent(tableName + ":" + tenantId, tid -> this.createTenantTable(tableName, tenantId));
    }

    public void execute(List<Function<Connection, Integer>> consumer) {
        try (Connection conn = this.getConnection();){
            for (Function<Connection, Integer> command : consumer) {
                int ret = command.apply(conn);
                if (ret != 0) continue;
                conn.rollback();
                throw new PostgresException((Throwable)new ConcurrentException("concurrent modification", null));
            }
            conn.commit();
        }
        catch (SQLException ex) {
            throw new PostgresException(ex);
        }
    }

    public int createEntityTable(Connection conn, String tableName) {
        int n;
        block8: {
            PreparedStatement stmt = conn.prepareStatement("create table if not exists " + tableName + " (tenantId varchar,brn varchar ,rootEntityType varchar ,rootId varchar , entityType varchar,entityId varchar,json json,lastseq bigint,timestamp bigint,primary key(tenantId,brn)) partition by LIST(tenantId)");
            try {
                boolean ok = stmt.execute();
                conn.commit();
                log.info("creating entity table {} executed , ret {}", (Object)tableName, (Object)ok);
                n = 1;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PostgresException(ex);
                }
            }
            stmt.close();
        }
        return n;
    }

    public int createEventTable(Connection conn, String tableName) {
        int n;
        block8: {
            tableName = (String)tableName + "Events";
            PreparedStatement stmt = conn.prepareStatement("create table if not exists " + (String)tableName + " (tenantId varchar,trn varchar,eventOwner varchar,eventOwnerId varchar,eventType varchar,eventSeq bigint,json json,timestamp bigint,primary key(tenantId,trn,eventSeq)) partition by LIST(tenantId)");
            try {
                boolean ok = stmt.execute();
                conn.commit();
                log.info("creating events table {} executed , ret {}", tableName, (Object)ok);
                n = 1;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PostgresException(ex);
                }
            }
            stmt.close();
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T executeQuery(Function<Connection, T> queryHandler) {
        try (Connection conn = this.getConnection();){
            Connection t = queryHandler.apply(conn);
            return (T)t;
        }
        catch (SQLException ex) {
            throw new PostgresException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String createTenantTable(String table, String tenantId) {
        log.info("creating tenant {} for table {} if not exist", (Object)tenantId, (Object)table);
        try (Connection conn = this.getConnection();){
            String string;
            block14: {
                PreparedStatement stmt = conn.prepareStatement("create table if not exists " + table + "_" + tenantId.replaceAll("-", "_") + " partition of " + table + " for values in ('" + tenantId + "')");
                try {
                    boolean ok = stmt.execute();
                    conn.commit();
                    log.info("creating tenant {} for table {} if not exist completed. {}", new Object[]{tenantId, table, ok});
                    string = tenantId;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return string;
        }
        catch (SQLException ex) {
            throw new PostgresException(ex);
        }
    }

    protected int insertEntity(Connection conn, String tableName, String tenantId, String rootEntityType, String rootId, String brn, String entityType, String entityId, String json, long lastSeq) {
        int n;
        block8: {
            this.createTenantIfNotExist(tableName, tenantId);
            PreparedStatement stmt = conn.prepareStatement("insert into " + tableName + " (tenantId,brn,rootEntityType,rootId,entityType,entityId,json,lastseq,timestamp) values(?,?,?,?,?,?,?,?,?)");
            try {
                stmt.setString(1, tenantId);
                stmt.setString(2, rootEntityType);
                stmt.setString(3, rootId);
                stmt.setString(4, brn);
                stmt.setString(5, entityType);
                stmt.setString(6, entityId);
                PGobject pGobject = new PGobject();
                pGobject.setType("json");
                pGobject.setValue(json);
                stmt.setObject(7, pGobject);
                stmt.setLong(8, lastSeq);
                stmt.setLong(9, System.currentTimeMillis());
                n = stmt.executeUpdate();
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PostgresException(ex);
                }
            }
            stmt.close();
        }
        return n;
    }

    protected int deleteChildEntityByRootId(Connection conn, String tableName, String tenantId, String rootEntityType, String rootId) {
        int n;
        block8: {
            this.createTenantIfNotExist(tableName, tenantId);
            PreparedStatement stmt = conn.prepareStatement("delete from " + tableName + " where tenantId = ? and rootEntityType = ? and rootId = ?");
            try {
                stmt.setString(1, tenantId);
                stmt.setString(2, rootEntityType);
                stmt.setString(3, rootId);
                stmt.executeUpdate();
                n = 1;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PostgresException(ex);
                }
            }
            stmt.close();
        }
        return n;
    }

    protected int deleteEventsByRootId(Connection conn, String tableName, String tenantId, String rootId) {
        int n;
        block8: {
            this.createTenantIfNotExist(tableName, tenantId);
            PreparedStatement stmt = conn.prepareStatement("delete from " + tableName + " where tenantId = ? and json->>'_rootId' = ?");
            try {
                stmt.setString(1, tenantId);
                stmt.setString(2, rootId);
                stmt.executeUpdate();
                n = 1;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PostgresException(ex);
                }
            }
            stmt.close();
        }
        return n;
    }

    protected int insertCheckpoint(Connection conn, String tableName, String tenantId, String brn, String entityType, String entityId, String json, long lastSeq) {
        int n;
        block8: {
            this.createTenantIfNotExist(tableName, tenantId);
            PreparedStatement stmt = conn.prepareStatement("insert into " + tableName + " (tenantId,brn,entityType,entityId,json,lastseq,timestamp) values(?,?,?,?,?,?,?) on conflict (tenantId,brn) do update set json = ? , timestamp  = ? , lastseq = ?");
            try {
                stmt.setString(1, tenantId);
                stmt.setString(2, brn);
                stmt.setString(3, entityType);
                stmt.setString(4, entityId);
                PGobject pGobject = new PGobject();
                pGobject.setType("json");
                pGobject.setValue(json);
                stmt.setObject(5, pGobject);
                stmt.setLong(6, lastSeq);
                stmt.setLong(7, System.currentTimeMillis());
                stmt.setObject(8, pGobject);
                stmt.setLong(9, System.currentTimeMillis());
                stmt.setLong(10, lastSeq);
                n = stmt.executeUpdate();
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PostgresException(ex);
                }
            }
            stmt.close();
        }
        return n;
    }

    protected int insertEvent(Connection conn, String tableName, String tenantId, String trn, String eventOwner, String eventOwnerId, String eventType, long eventSeq, String json) {
        int n;
        block8: {
            this.createTenantIfNotExist(tableName, tenantId);
            PreparedStatement stmt = conn.prepareStatement("insert into " + tableName + " (tenantId,trn,eventOwner,eventOwnerId,eventType,eventSeq,json,timestamp) values(?,?,?,?,?,?,?,?) ");
            try {
                stmt.setString(1, tenantId);
                stmt.setString(2, trn);
                stmt.setString(3, eventOwner);
                stmt.setString(4, eventOwnerId);
                stmt.setString(5, eventType);
                stmt.setLong(6, eventSeq);
                PGobject pGobject = new PGobject();
                pGobject.setType("json");
                pGobject.setValue(json);
                stmt.setObject(7, pGobject);
                stmt.setLong(8, System.currentTimeMillis());
                n = stmt.executeUpdate();
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PostgresException(ex);
                }
            }
            stmt.close();
        }
        return n;
    }

    protected int deleteEventsByTrn(Connection conn, String tableName, String tenantId, String trn, String eventOwner, String eventOwnerId) {
        int n;
        block8: {
            this.createTenantIfNotExist(tableName, tenantId);
            String sql = "delete from " + tableName + " where tenantId = ? and trn = ? and eventOwner = ? and eventOwnerId = ?";
            log.info("deleteEventsByTrn : " + sql);
            PreparedStatement stmt = conn.prepareStatement(sql);
            try {
                stmt.setString(1, tenantId);
                stmt.setString(2, trn);
                stmt.setString(3, eventOwner);
                stmt.setString(4, eventOwnerId);
                n = stmt.executeUpdate();
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PostgresException(ex);
                }
            }
            stmt.close();
        }
        return n;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected ResultSet<String> getEvents(Connection conn, String tableName, String tenantId, String trn, String eventOwner, String eventOwnerId, String filter, String orderBy, int pageNum, int pageSize) {
        PostgresSqlNode sqlNode;
        RestQLNode qlNode;
        this.createTenantIfNotExist(tableName, tenantId);
        String filterSql = null;
        String orderBySql = null;
        if (filter != null) {
            qlNode = RestQLParser.parse((String)filter);
            sqlNode = new PostgresSqlNode();
            filterSql = sqlNode.eval(qlNode);
        }
        if (orderBy != null) {
            qlNode = RestQLParser.parseOrderBy((String)orderBy);
            sqlNode = new PostgresSqlNode();
            orderBySql = sqlNode.eval(qlNode);
        } else {
            orderBy = "eventSeq desc";
        }
        long total = this.getTotalEventsCount(conn, tableName, tenantId, trn, eventOwner, eventOwnerId, filter);
        String sqlQuery = "select json from " + tableName + " where trn = ? and tenantId = ? and eventOwner = ? and eventOwnerId = ? " + (String)(filterSql != null ? " and " + filterSql : "") + (String)(orderBySql != null ? " order By " + orderBySql : "") + (String)(orderBy != null ? " limit " + pageSize + " offset " + pageNum * pageSize : "");
        log.info("getEvents : " + sqlQuery);
        try (PreparedStatement stmt = conn.prepareStatement(sqlQuery);){
            ResultSet resultSet;
            block18: {
                stmt.setString(1, trn);
                stmt.setString(2, tenantId);
                stmt.setString(3, eventOwner);
                stmt.setString(4, eventOwnerId);
                java.sql.ResultSet rs = stmt.executeQuery();
                try {
                    System.out.println("fetch size : " + rs.getFetchSize());
                    LinkedList<String> list = new LinkedList<String>();
                    while (rs.next()) {
                        list.add(rs.getString("json"));
                    }
                    resultSet = new ResultSet(total, (int)Math.ceil((double)total / (double)pageSize), pageNum, list);
                    if (rs == null) break block18;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return resultSet;
        }
        catch (SQLException ex) {
            throw new PostgresException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected long getTotalEventsCount(Connection conn, String tableName, String tenantId, String trn, String eventOwner, String eventOwnerId, String filter) {
        this.createTenantIfNotExist(tableName, tenantId);
        String filterSql = null;
        if (filter != null) {
            RestQLNode qlNode = RestQLParser.parse((String)filter);
            PostgresSqlNode sqlNode = new PostgresSqlNode();
            filterSql = sqlNode.eval(qlNode);
        }
        String sqlQuery = "select count(*) as totalCount  from " + tableName + " where trn = ? and tenantId = ? and eventOwner = ? and eventOwnerId = ? " + (String)(filterSql != null ? " and " + filterSql : "");
        try (PreparedStatement stmt = conn.prepareStatement(sqlQuery);){
            long l;
            block19: {
                java.sql.ResultSet rs;
                block17: {
                    long l2;
                    block18: {
                        stmt.setString(1, trn);
                        stmt.setString(2, tenantId);
                        stmt.setString(3, eventOwner);
                        stmt.setString(4, eventOwnerId);
                        rs = stmt.executeQuery();
                        try {
                            System.out.println("fetch size : " + rs.getFetchSize());
                            if (!rs.next()) break block17;
                            l2 = rs.getLong("totalCount");
                            if (rs == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return l2;
                }
                l = 0L;
                if (rs == null) break block19;
                rs.close();
            }
            return l;
        }
        catch (SQLException ex) {
            throw new PostgresException(ex);
        }
    }

    protected int updateEntity(Connection conn, String tableName, String tenantId, String brn, String entityType, String entityId, String json, long lastSeq, long updatedSeq) {
        int n;
        block8: {
            this.createTenantIfNotExist(tableName, tenantId);
            PreparedStatement stmt = conn.prepareStatement("update " + tableName + " set brn = ?, json = ? , lastseq = ?  ,timestamp = ?  where tenantId = ? and lastSeq = ? and entityType = ? and entityId = ?");
            try {
                stmt.setString(1, brn);
                PGobject pGobject = new PGobject();
                pGobject.setType("json");
                pGobject.setValue(json);
                stmt.setObject(2, pGobject);
                stmt.setLong(3, updatedSeq);
                stmt.setLong(4, System.currentTimeMillis());
                stmt.setString(5, tenantId);
                stmt.setLong(6, lastSeq);
                stmt.setString(7, entityType);
                stmt.setString(8, entityId);
                n = stmt.executeUpdate();
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PostgresException(ex);
                }
            }
            stmt.close();
        }
        return n;
    }

    protected int deleteEntity(Connection conn, String tableName, String tenantId, String brn, String entityId) {
        int n;
        block8: {
            this.createTenantIfNotExist(tableName, tenantId);
            PreparedStatement stmt = conn.prepareStatement("delete from " + tableName + " where tenantId = ? and brn = ? and entityId = ?");
            try {
                stmt.setString(1, tenantId);
                stmt.setString(2, brn);
                stmt.setString(3, entityId);
                n = stmt.executeUpdate();
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PostgresException(ex);
                }
            }
            stmt.close();
        }
        return n;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Optional<String> getEntityByBrn(Connection conn, String tableName, String brn, String tenantId) {
        this.createTenantIfNotExist(tableName, tenantId);
        try (PreparedStatement stmt = conn.prepareStatement("select json from " + tableName + " where brn = ? and tenantId = ?");){
            Optional<String> optional;
            block18: {
                java.sql.ResultSet rs;
                block16: {
                    Optional<String> optional2;
                    block17: {
                        stmt.setString(1, brn);
                        stmt.setString(2, tenantId);
                        rs = stmt.executeQuery();
                        try {
                            if (!rs.next()) break block16;
                            optional2 = Optional.of(rs.getString("json"));
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return optional2;
                }
                optional = Optional.empty();
                if (rs == null) break block18;
                rs.close();
            }
            return optional;
        }
        catch (SQLException ex) {
            throw new PostgresException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Optional<String> getEntityByTrn(Connection conn, String tableName, String entityType, String id, String tenantId) {
        this.createTenantIfNotExist(tableName, tenantId);
        try (PreparedStatement stmt = conn.prepareStatement("select json from " + tableName + " where entityType = ? and entityId = ? and tenantId = ?");){
            Optional<String> optional;
            block18: {
                java.sql.ResultSet rs;
                block16: {
                    Optional<String> optional2;
                    block17: {
                        stmt.setString(1, entityType);
                        stmt.setString(2, id);
                        stmt.setString(3, tenantId);
                        rs = stmt.executeQuery();
                        try {
                            if (!rs.next()) break block16;
                            optional2 = Optional.of(rs.getString("json"));
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return optional2;
                }
                optional = Optional.empty();
                if (rs == null) break block18;
                rs.close();
            }
            return optional;
        }
        catch (SQLException ex) {
            throw new PostgresException(ex);
        }
    }

    protected ResultSet<String> getRootEntityByType(Connection conn, String tableName, String rootEntityType, List<String> tenantIds, String filter, String orderBy, int pageNum, int pageSize) {
        ResultSet resultSet;
        block19: {
            PostgresSqlNode sqlNode;
            RestQLNode qlNode;
            String filterSql = null;
            String orderBySql = null;
            if (filter != null) {
                qlNode = RestQLParser.parse((String)filter);
                sqlNode = new PostgresSqlNode();
                filterSql = sqlNode.eval(qlNode);
            }
            if (orderBy != null) {
                qlNode = RestQLParser.parseOrderBy((String)orderBy);
                sqlNode = new PostgresSqlNode();
                orderBySql = sqlNode.eval(qlNode);
            }
            tenantIds.forEach(tenantId -> this.createTenantIfNotExist(tableName, (String)tenantId));
            long total = this.getRootEntityByTypeCount(conn, tableName, rootEntityType, tenantIds, filter);
            String tenantQuery = "(" + tenantIds.stream().map(t -> "tenantId = ?").collect(Collectors.joining(" or ")) + ")";
            String sql = "select json from " + tableName + " where rootEntityType = ?  and entityType = ? and " + tenantQuery + (String)(filterSql != null ? " and " + filterSql : "") + (String)(orderBySql != null ? " order By " + orderBySql : "") + (String)(orderBy != null ? " limit " + pageSize + " offset " + pageNum * pageSize : "");
            log.info("getRootEntityByType : " + sql);
            LinkedList<String> list = new LinkedList<String>();
            PreparedStatement stmt = conn.prepareStatement(sql);
            try {
                stmt.setString(1, rootEntityType);
                stmt.setString(2, rootEntityType);
                int i = 3;
                for (String tenantId2 : tenantIds) {
                    stmt.setString(i++, tenantId2);
                }
                try (java.sql.ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        list.add(rs.getString("json"));
                    }
                }
                resultSet = new ResultSet(total, (int)Math.ceil((double)total / (double)pageSize), pageNum, list);
                if (stmt == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PostgresException(ex);
                }
            }
            stmt.close();
        }
        return resultSet;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected long getRootEntityByTypeCount(Connection conn, String tableName, String rootEntityType, List<String> tenantIds, String filter) {
        String filterSql = null;
        if (filter != null) {
            RestQLNode qlNode = RestQLParser.parse((String)filter);
            PostgresSqlNode sqlNode = new PostgresSqlNode();
            filterSql = sqlNode.eval(qlNode);
        }
        tenantIds.forEach(tenantId -> this.createTenantIfNotExist(tableName, (String)tenantId));
        String tenantQuery = "(" + tenantIds.stream().map(t -> "tenantId = ?").collect(Collectors.joining(" or ")) + ")";
        String sql = "select count(*) as totalCount from " + tableName + " where rootEntityType = ?  and entityType = ? and " + tenantQuery + (String)(filterSql != null ? "and " + filterSql : "");
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            long l;
            block20: {
                java.sql.ResultSet rs;
                block18: {
                    long l2;
                    block19: {
                        stmt.setString(1, rootEntityType);
                        stmt.setString(2, rootEntityType);
                        int i = 3;
                        for (String tenantId2 : tenantIds) {
                            stmt.setString(i++, tenantId2);
                        }
                        rs = stmt.executeQuery();
                        try {
                            if (!rs.next()) break block18;
                            l2 = rs.getLong("totalCount");
                            if (rs == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return l2;
                }
                l = 0L;
                if (rs == null) break block20;
                rs.close();
            }
            return l;
        }
        catch (SQLException ex) {
            throw new PostgresException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected long getChildEntityByTypeCount(Connection conn, String tableName, String rootEntityType, String rootId, String entityType, List<String> tenantIds, String filter) {
        tenantIds.forEach(tenantId -> this.createTenantIfNotExist(tableName, (String)tenantId));
        String filterSql = null;
        if (filter != null) {
            RestQLNode qlNode = RestQLParser.parse((String)filter);
            PostgresSqlNode sqlNode = new PostgresSqlNode();
            filterSql = sqlNode.eval(qlNode);
        }
        String tenantQuery = "(" + tenantIds.stream().map(t -> "tenantId = ?").collect(Collectors.joining(" or ")) + ")";
        String sql = "select count(*) as TotalCount from " + tableName + " where rootEntityType = ? and rootId = ? and entityType = ?  and " + tenantQuery + (String)(filterSql != null ? "and " + filterSql : "");
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            long l;
            block20: {
                java.sql.ResultSet rs;
                block18: {
                    long l2;
                    block19: {
                        stmt.setString(1, rootEntityType);
                        stmt.setString(2, rootId);
                        stmt.setString(3, entityType);
                        int i = 4;
                        for (String tenantId2 : tenantIds) {
                            stmt.setString(i++, tenantId2);
                        }
                        rs = stmt.executeQuery();
                        try {
                            if (!rs.next()) break block18;
                            l2 = rs.getLong("TotalCount");
                            if (rs == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return l2;
                }
                l = 0L;
                if (rs == null) break block20;
                rs.close();
            }
            return l;
        }
        catch (SQLException ex) {
            throw new PostgresException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected ResultSet<String> getChildEntityByType(Connection conn, String tableName, String rootEntityType, String rootId, String entityType, List<String> tenantIds, String filter, String orderBy, int pageNum, int pageSize) {
        PostgresSqlNode sqlNode;
        RestQLNode qlNode;
        tenantIds.forEach(tenantId -> this.createTenantIfNotExist(tableName, (String)tenantId));
        String tenantQuery = "(" + tenantIds.stream().map(t -> "tenantId = ?").collect(Collectors.joining(" or ")) + ")";
        String filterSql = null;
        String orderBySql = null;
        if (filter != null) {
            qlNode = RestQLParser.parse((String)filter);
            sqlNode = new PostgresSqlNode();
            filterSql = sqlNode.eval(qlNode);
        }
        if (orderBy != null) {
            qlNode = RestQLParser.parseOrderBy((String)orderBy);
            sqlNode = new PostgresSqlNode();
            orderBySql = sqlNode.eval(qlNode);
        }
        long total = this.getChildEntityByTypeCount(conn, tableName, rootEntityType, rootId, entityType, tenantIds, filter);
        String sql = "select json from " + tableName + " where rootEntityType = ? and rootId = ? and entityType = ?  and " + tenantQuery + (String)(filterSql != null ? "and " + filterSql : "") + (String)(orderBySql != null ? " order By " + orderBySql : "") + (String)(orderBy != null ? " limit " + pageSize + " offset " + pageNum * pageSize : "");
        log.info("getChildEntityByType : " + sql);
        LinkedList<String> list = new LinkedList<String>();
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            ResultSet resultSet;
            block18: {
                stmt.setString(1, rootEntityType);
                stmt.setString(2, rootId);
                stmt.setString(3, entityType);
                int i = 4;
                for (String tenantId2 : tenantIds) {
                    stmt.setString(i++, tenantId2);
                }
                java.sql.ResultSet rs = stmt.executeQuery();
                try {
                    while (rs.next()) {
                        list.add(rs.getString("json"));
                    }
                    resultSet = new ResultSet(total, (int)Math.ceil((double)total / (double)pageSize), pageNum, list);
                    if (rs == null) break block18;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return resultSet;
        }
        catch (SQLException ex) {
            throw new PostgresException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean isIdExist(Connection conn, String tableName, String id, String tenantId) {
        this.createTenantIfNotExist(tableName, tenantId);
        try (PreparedStatement stmt = conn.prepareStatement("select 1 from " + tableName + " where entityId = ? and tenantId = ? limit 1");){
            boolean bl;
            block14: {
                stmt.setString(1, id);
                stmt.setString(2, tenantId);
                java.sql.ResultSet rs = stmt.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            throw new PostgresException(ex);
        }
    }

    public <T extends RootEntity> EventRepositoy<T> createOrGetRepository(Class<T> rootType) {
        return mapRepos.computeIfAbsent(rootType, type -> new PostgresEventRepository(this, type, this.helper, this.providerConfig));
    }

    protected java.sql.ResultSet executeRawQuery(Connection conn, String query) {
        log.info("raw query : " + query);
        try {
            Statement stmt = conn.createStatement();
            return stmt.executeQuery(query);
        }
        catch (SQLException ex) {
            throw new PostgresException(ex);
        }
    }

    public SqlResultSet executeCustomRawQuery(Function<Connection, java.sql.ResultSet> queryHandler) {
        Connection conn = this.getConnection();
        return new SqlResultSet(conn, queryHandler.apply(conn));
    }
}

