/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.repo;

import com.cloudimpl.rstack.dsl.restql.BinNode;
import com.cloudimpl.rstack.dsl.restql.ConstArrayNode;
import com.cloudimpl.rstack.dsl.restql.ConstBooleanArrayNode;
import com.cloudimpl.rstack.dsl.restql.ConstBooleanNode;
import com.cloudimpl.rstack.dsl.restql.ConstNode;
import com.cloudimpl.rstack.dsl.restql.ConstNumberArrayNode;
import com.cloudimpl.rstack.dsl.restql.ConstNumberNode;
import com.cloudimpl.rstack.dsl.restql.ConstStringArrayNode;
import com.cloudimpl.rstack.dsl.restql.ConstStringNode;
import com.cloudimpl.rstack.dsl.restql.OrderByExpNode;
import com.cloudimpl.rstack.dsl.restql.OrderByNode;
import com.cloudimpl.rstack.dsl.restql.RelNode;
import com.cloudimpl.rstack.dsl.restql.RestQLNode;
import com.cloudimpl.rstack.dsl.restql.RestQLParser;
import com.google.gson.JsonObject;
import java.util.stream.Collectors;

public class PostgresSqlNode
implements RestQLNode {
    public String eval(RestQLNode node) {
        if (node instanceof ConstArrayNode) {
            return ((ConstArrayNode)ConstArrayNode.class.cast(node)).getVals().toString();
        }
        if (node instanceof ConstStringNode) {
            return String.valueOf(((ConstStringNode)ConstStringNode.class.cast(node)).getVal());
        }
        if (node instanceof ConstNumberNode) {
            return String.valueOf(((ConstNumberNode)ConstNumberNode.class.cast(node)).getVal());
        }
        if (node instanceof ConstBooleanNode) {
            return String.valueOf(((ConstBooleanNode)ConstBooleanNode.class.cast(node)).getVal());
        }
        if (node instanceof RelNode) {
            RelNode rel = (RelNode)RelNode.class.cast(node);
            if (rel.getOp() == RelNode.Op.IN) {
                return this.inOperator(rel);
            }
            return PostgresSqlNode.castToType(PostgresSqlNode.convertToJsonField(rel.getFieldName()), rel.getConstNode()) + (rel.getOp() == RelNode.Op.LIKE ? " ILIKE " : (rel.getOp() == RelNode.Op.NOT_LIKE ? " NOT ILIKE " : rel.getOp().getOp())) + (String)rel.getConstNode().eval((RestQLNode)this);
        }
        if (node instanceof BinNode) {
            BinNode binNode = (BinNode)BinNode.class.cast(node);
            return "(" + binNode.getLeft().eval((RestQLNode)this) + binNode.getOp().getOp() + binNode.getRight().eval((RestQLNode)this) + ")";
        }
        if (node instanceof OrderByNode) {
            OrderByNode orderBy = (OrderByNode)OrderByNode.class.cast(node);
            return PostgresSqlNode.castToType(PostgresSqlNode.convertToJsonField(orderBy.getFieldName()), orderBy.getDataType()) + " " + orderBy.getOrder();
        }
        if (node instanceof OrderByExpNode) {
            OrderByExpNode expNode = (OrderByExpNode)OrderByExpNode.class.cast(node);
            return expNode.getOrderByList().stream().map(i -> (String)i.eval((RestQLNode)this)).collect(Collectors.joining(","));
        }
        throw new RuntimeException("unknown node :" + node.getClass().getName());
    }

    public JsonObject toJson() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String inOperator(RelNode relNode) {
        ConstNode constNode = relNode.getConstNode();
        if (constNode instanceof ConstStringArrayNode) {
            return PostgresSqlNode.convertToJsonField(relNode.getFieldName()) + " IN (" + ((ConstStringArrayNode)ConstStringArrayNode.class.cast(constNode)).getVals().stream().collect(Collectors.joining(",")) + ")";
        }
        if (constNode instanceof ConstNumberArrayNode) {
            return PostgresSqlNode.convertToJsonField(relNode.getFieldName()) + " IN (" + ((ConstNumberArrayNode)ConstNumberArrayNode.class.cast(constNode)).getVals().stream().map(v -> v.toString()).collect(Collectors.joining(",")) + ")";
        }
        if (constNode instanceof ConstBooleanArrayNode) {
            return PostgresSqlNode.convertToJsonField(relNode.getFieldName()) + " IN (" + ((ConstBooleanArrayNode)ConstBooleanArrayNode.class.cast(constNode)).getVals().stream().map(v -> v.toString()).collect(Collectors.joining(",")) + ")";
        }
        throw new RuntimeException("unknown const array node :" + constNode.getClass().getName());
    }

    public static String convertToJsonField(String field) {
        if (field.equals("_eventType")) {
            return field.substring(1);
        }
        String[] fields = field.split("\\.");
        if (fields.length == 1) {
            return "json->>'" + field + "'";
        }
        if (fields.length == 2) {
            return "json->'" + fields[0] + "'->>'" + fields[1] + "'";
        }
        throw new RuntimeException("invalid field format");
    }

    public static String castToType(String fieldName, ConstNode constNode) {
        if (constNode instanceof ConstNumberNode) {
            return "(" + fieldName + ")::numeric";
        }
        if (constNode instanceof ConstBooleanNode) {
            return "(" + fieldName + ")::bool";
        }
        return fieldName;
    }

    public static String castToType(String fieldName, OrderByNode.DataType dataType) {
        switch (dataType) {
            case BOOL: {
                return "(" + fieldName + ")::bool";
            }
            case NUMBER: {
                return "(" + fieldName + ")::numeric";
            }
            case STRING: {
                return fieldName;
            }
        }
        return fieldName;
    }

    public static void main(String[] args) {
        OrderByExpNode node = RestQLParser.parseOrderBy((String)"N(seqNum):DESC");
        PostgresSqlNode postgersNode = new PostgresSqlNode();
        String sql = postgersNode.eval((RestQLNode)node);
        System.out.println("sql : " + sql);
        RestQLNode parse = RestQLParser.parse((String)"read=false");
        PostgresSqlNode postgersNode2 = new PostgresSqlNode();
        String sql2 = postgersNode2.eval(parse);
        System.out.println("sql2 : " + sql2);
    }
}

