/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.spring.security.AuthenticationMeta;
import com.cloudimpl.outstack.spring.security.GrantType;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationException;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationToken;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class Auth2Util {
    public static AuthenticationMeta createAuthMeta(String authKey, String context, ServerWebExchange exchange) {
        PlatformAuthenticationToken.TokenFlow flow = Auth2Util.createFlow(exchange);
        return new AuthenticationMeta(flow, authKey, context, Auth2Util.getGrantType(flow, exchange), Auth2Util.getClientMeta(exchange));
    }

    public static PlatformAuthenticationToken.TokenFlow createFlow(ServerWebExchange exchange) {
        String path = exchange.getRequest().getPath().pathWithinApplication().value();
        if (path.equals("/login")) {
            return PlatformAuthenticationToken.TokenFlow.AUTHENTICATION_FLOW;
        }
        if (path.equals("/token")) {
            return PlatformAuthenticationToken.TokenFlow.TOKEN_FLOW;
        }
        return PlatformAuthenticationToken.TokenFlow.AUTHORIZATION_FLOW;
    }

    public static GrantType getGrantType(PlatformAuthenticationToken.TokenFlow tokenFlow, ServerWebExchange exchange) {
        if (tokenFlow == PlatformAuthenticationToken.TokenFlow.TOKEN_FLOW) {
            String type = (String)exchange.getRequest().getQueryParams().getFirst((Object)"grant_type");
            return GrantType.from(type);
        }
        return null;
    }

    public static AuthenticationMeta.ClientMeta getClientMeta(ServerWebExchange exchange) {
        ServerHttpRequest req = exchange.getRequest();
        String clientId = (String)req.getQueryParams().getFirst((Object)"client_id");
        String clientSecret = (String)req.getQueryParams().getFirst((Object)"client_secret");
        String codeVerfier = (String)req.getQueryParams().getFirst((Object)"code_verifier");
        String code = (String)req.getQueryParams().getFirst((Object)"code");
        String redirectUri = (String)req.getQueryParams().getFirst((Object)"redirect_uri");
        String accessType = (String)req.getQueryParams().getFirst((Object)"access_type");
        String tenantId = req.getHeaders().getFirst("X-TenantId");
        String userAgent = req.getHeaders().getFirst("User-Agent");
        String userData = req.getHeaders().getFirst("X-UserData");
        String state = (String)req.getQueryParams().getFirst((Object)"state");
        String codeChallenge = (String)req.getQueryParams().getFirst((Object)"code_challenge");
        String codeChallengeMethod = (String)req.getQueryParams().getFirst((Object)"code_challenge_method");
        String remoteIp = req.getRemoteAddress().toString();
        return new AuthenticationMeta.ClientMeta(clientId, clientSecret, code, redirectUri, codeVerfier, tenantId, accessType, userAgent, remoteIp, userData, state, codeChallenge, codeChallengeMethod);
    }

    public static void validateAuthentcationMeta(Object detail) {
        if (detail == null || !(detail instanceof AuthenticationMeta)) {
            throw new PlatformAuthenticationException("meta data not found in the token", null);
        }
    }
}

